/*
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * dialog.c - code to deal with dialog boxes.
 */

#include "vncviewer.h"
#include <X11/Xaw/Dialog.h>

static Bool serverDialogDone = False;
static Bool passwordDialogDone = False;
static Bool ycropDialogDone = False;
static Bool scbarDialogDone = False;
static Bool scaleDialogDone = False;
static Bool qualityDialogDone = False;
static Bool compressDialogDone = False;

extern void popupFixer(Widget wid);

void
YCropDialogDone(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  ycropDialogDone = True;
}

char *
DoYCropDialog()
{
  Widget pshell, dialog;
  char *ycropValue;
  char *valueString;

  pshell = XtVaCreatePopupShell("ycropDialog", transientShellWidgetClass,
				toplevel, NULL);
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, pshell, NULL);

  XtMoveWidget(pshell, WidthOfScreen(XtScreen(pshell))*2/5,
	       HeightOfScreen(XtScreen(pshell))*2/5);
  XtPopup(pshell, XtGrabNonexclusive);
  XtRealizeWidget(pshell);

  if (appData.popupFix) {
	popupFixer(pshell);
  }

  ycropDialogDone = False;

  while (!ycropDialogDone) {
    XtAppProcessEvent(appContext, XtIMAll);
  }

  valueString = XawDialogGetValueString(dialog);
  ycropValue = XtNewString(valueString);

  XtPopdown(pshell);
  return ycropValue;
}

void
ScbarDialogDone(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  scbarDialogDone = True;
}

char *
DoScbarDialog()
{
  Widget pshell, dialog;
  char *scbarValue;
  char *valueString;

  pshell = XtVaCreatePopupShell("scbarDialog", transientShellWidgetClass,
				toplevel, NULL);
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, pshell, NULL);

  XtMoveWidget(pshell, WidthOfScreen(XtScreen(pshell))*2/5,
	       HeightOfScreen(XtScreen(pshell))*2/5);
  XtPopup(pshell, XtGrabNonexclusive);
  XtRealizeWidget(pshell);

  if (appData.popupFix) {
	popupFixer(pshell);
  }

  scbarDialogDone = False;

  while (!scbarDialogDone) {
    XtAppProcessEvent(appContext, XtIMAll);
  }

  valueString = XawDialogGetValueString(dialog);
  scbarValue = XtNewString(valueString);

  XtPopdown(pshell);
  return scbarValue;
}

void
ScaleDialogDone(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  scaleDialogDone = True;
}

char *
DoScaleDialog()
{
  Widget pshell, dialog;
  char *scaleValue;
  char *valueString;

  pshell = XtVaCreatePopupShell("scaleDialog", transientShellWidgetClass,
				toplevel, NULL);
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, pshell, NULL);

  XtMoveWidget(pshell, WidthOfScreen(XtScreen(pshell))*2/5,
	       HeightOfScreen(XtScreen(pshell))*2/5);
  XtPopup(pshell, XtGrabNonexclusive);
  XtRealizeWidget(pshell);

  if (appData.popupFix) {
	popupFixer(pshell);
  }

  scaleDialogDone = False;

  while (!scaleDialogDone) {
    XtAppProcessEvent(appContext, XtIMAll);
  }

  valueString = XawDialogGetValueString(dialog);
  scaleValue = XtNewString(valueString);

  XtPopdown(pshell);
  return scaleValue;
}

void
QualityDialogDone(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  qualityDialogDone = True;
}

char *
DoQualityDialog()
{
  Widget pshell, dialog;
  char *qualityValue;
  char *valueString;

  pshell = XtVaCreatePopupShell("qualityDialog", transientShellWidgetClass,
				toplevel, NULL);
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, pshell, NULL);

  XtMoveWidget(pshell, WidthOfScreen(XtScreen(pshell))*2/5,
	       HeightOfScreen(XtScreen(pshell))*2/5);
  XtPopup(pshell, XtGrabNonexclusive);
  XtRealizeWidget(pshell);

  if (appData.popupFix) {
	popupFixer(pshell);
  }

  qualityDialogDone = False;

  while (!qualityDialogDone) {
    XtAppProcessEvent(appContext, XtIMAll);
  }

  valueString = XawDialogGetValueString(dialog);
  qualityValue = XtNewString(valueString);

  XtPopdown(pshell);
  return qualityValue;
}

void
CompressDialogDone(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  compressDialogDone = True;
}

char *
DoCompressDialog()
{
  Widget pshell, dialog;
  char *compressValue;
  char *valueString;

  pshell = XtVaCreatePopupShell("compressDialog", transientShellWidgetClass,
				toplevel, NULL);
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, pshell, NULL);

  XtMoveWidget(pshell, WidthOfScreen(XtScreen(pshell))*2/5,
	       HeightOfScreen(XtScreen(pshell))*2/5);
  XtPopup(pshell, XtGrabNonexclusive);
  XtRealizeWidget(pshell);

  if (appData.popupFix) {
	popupFixer(pshell);
  }

  compressDialogDone = False;

  while (!compressDialogDone) {
    XtAppProcessEvent(appContext, XtIMAll);
  }

  valueString = XawDialogGetValueString(dialog);
  compressValue = XtNewString(valueString);

  XtPopdown(pshell);
  return compressValue;
}

void
ServerDialogDone(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  serverDialogDone = True;
}

char *
DoServerDialog()
{
  Widget pshell, dialog;
  char *vncServerName;
  char *valueString;

  pshell = XtVaCreatePopupShell("serverDialog", transientShellWidgetClass,
				toplevel, NULL);
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, pshell, NULL);

  XtMoveWidget(pshell, WidthOfScreen(XtScreen(pshell))*2/5,
	       HeightOfScreen(XtScreen(pshell))*2/5);
  XtPopup(pshell, XtGrabNonexclusive);
  XtRealizeWidget(pshell);

  if (appData.popupFix) {
	popupFixer(pshell);
  }

  serverDialogDone = False;

  while (!serverDialogDone) {
    XtAppProcessEvent(appContext, XtIMAll);
  }

  valueString = XawDialogGetValueString(dialog);
  vncServerName = XtNewString(valueString);

  XtPopdown(pshell);
  return vncServerName;
}

void
PasswordDialogDone(Widget w, XEvent *event, String *params,
		   Cardinal *num_params)
{
  passwordDialogDone = True;
}

char *
DoPasswordDialog()
{
  Widget pshell, dialog;
  char *password;
  char *valueString;

  pshell = XtVaCreatePopupShell("passwordDialog", transientShellWidgetClass,
				toplevel, NULL);
  dialog = XtVaCreateManagedWidget("dialog", dialogWidgetClass, pshell, NULL);

  XtMoveWidget(pshell, WidthOfScreen(XtScreen(pshell))*2/5,
	       HeightOfScreen(XtScreen(pshell))*2/5);
  XtPopup(pshell, XtGrabNonexclusive);
  XtRealizeWidget(pshell);

  if (appData.popupFix) {
	popupFixer(pshell);
  }

  passwordDialogDone = False;

  while (!passwordDialogDone) {
    XtAppProcessEvent(appContext, XtIMAll);
  }

  valueString = XawDialogGetValueString(dialog);
  password = XtNewString(valueString);

  XtPopdown(pshell);
  return password;
}
