/*
For general Sqliteman copyright and licensing information please refer
to the COPYING file provided with the program. Following this notice may exist
a copyright and/or license notice that predates the release of Sqliteman
for which a new license (GPL+exception) is in place.
*/

#include <QColor>
#include <QSqlField>

#include "sqlmodels.h"
#include "database.h"

#include <QtDebug>
// ItemDelegate::ItemDelegate(QObject *parent)
//      : QItemDelegate(parent)
// {
// 	qDebug() << "ItemDelegate::ItemDelegate(QObject *parent)";
// 	newBlob = QByteArray();
// 	loadButton = new QPushButton(tr("Load"));
// 	connect(loadButton, SIGNAL(clicked()), this, SLOT(loadBlob()));
// }
// 
// QWidget * ItemDelegate::createEditor(QWidget *parent,
//      const QStyleOptionViewItem &/* option */,
//      const QModelIndex &/* index */) const
// {
// 	return loadButton;
// }
// 
// void ItemDelegate::loadBlob()
// {
// 	QString fname = QFileDialog::getOpenFileName(loadButton, tr("Open File for BLOB"),
//                                                  QDir::currentPath(),
//                                                  tr("All files (*)"));
// 	if (fname.isNull())
// 		return;
// 	QFile f(fname);
// 	if (f.open(QFile::ReadOnly))
// 		newBlob = QFile(fname).readAll();
// 	f.close();
// }
// 
// void ItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
// {
// }
// 
// void ItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
//                                    const QModelIndex &index) const
// {
// 	if (newBlob.isEmpty() || newBlob.isNull())
// 		return;
// 	model->setData(index, newBlob);
// }
// 
// void ItemDelegate::updateEditorGeometry(QWidget *editor,
//     const QStyleOptionViewItem &option, const QModelIndex &/* index */) const
// {
//     editor->setGeometry(option.rect);
// }


SqlTableModel::SqlTableModel(QObject * parent, QSqlDatabase db)
	: QSqlTableModel(parent, db),
	m_schema("")
{
	m_useNull = PreferencesDialog::useNullHighlight();
	m_nullColor = PreferencesDialog::nullHighlightColor();
	m_nullText = PreferencesDialog::nullHighlightText();
	m_useBlob = PreferencesDialog::useBlobHighlight();
	m_blobColor = PreferencesDialog::blobHighlightColor();
	m_blobText = PreferencesDialog::blobHighlightText();
}

QVariant SqlTableModel::data(const QModelIndex & item, int role) const
{
	QString curr(QSqlTableModel::data(item, Qt::DisplayRole).toString());

	// nulls
	// FIXME: rewrite to the QSqlField::isNull?
	if (m_useNull && (curr.isNull() || curr.isEmpty()))
	{
		if (role == Qt::BackgroundColorRole)
			return QVariant(m_nullColor);
		if (role == Qt::ToolTipRole)
			return QVariant(tr("NULL value"));
		if (role == Qt::DisplayRole)
			return QVariant(m_nullText);
	}
	// BLOBs
		// propably not needed as the check against QVariant::ByteArray solves it. Propably
// 		DatabaseTableField f;
// 		foreach (DatabaseTableField col, Database::tableFields(tableName(), m_schema))
// 		{
// 			if (col.name == headerData(item.column(), Qt::Horizontal, Qt::DisplayRole))
// 			{
// 				f = col;
// 				break;
// 			}
// 		}

	if (/*f.type.toUpper() == "BLOB" || */
		m_useBlob &&
		record().field(item.column()).type() == QVariant::ByteArray)
	{
		if (role == Qt::BackgroundColorRole)
			return QVariant(m_blobColor);
		if (role == Qt::ToolTipRole)
			return QVariant(tr("BLOB value"));
		if (role == Qt::DisplayRole)
			return QVariant(m_blobText);
		if (role == Qt::EditRole)
			return Database::hex(QSqlTableModel::data(item, Qt::DisplayRole).toByteArray());
	}
	if (role == Qt::ToolTipRole)
		return QVariant(curr.length() > 6 ? curr.left(6)+"..." : "");
	return QSqlTableModel::data(item, role);
}

SqlQueryModel::SqlQueryModel( QObject * parent)
	: QSqlQueryModel(parent)
{
}

QVariant SqlQueryModel::data(const QModelIndex & item, int role) const
{
	QString curr(QSqlQueryModel::data(item, Qt::DisplayRole).toString());

	if (m_useNull && (curr.isNull() || curr.isEmpty()))
	{
		if (role == Qt::BackgroundColorRole)
			return QVariant(m_nullColor);
		if (role == Qt::ToolTipRole)
			return QVariant(tr("NULL value"));
		if (role == Qt::DisplayRole)
			return QVariant(m_nullText);
	}

	if (m_useBlob && info.field(item.column()).type() == QVariant::ByteArray)
	{
		if (role == Qt::BackgroundColorRole)
			return QVariant(m_blobColor);
		if (role == Qt::ToolTipRole)
			return QVariant(tr("BLOB value"));
		if (role == Qt::DisplayRole)
			return QVariant(m_blobText);
	}
	if (role == Qt::ToolTipRole)
		return QVariant(curr.length() > 6 ? curr.left(6)+"..." : "");
	return QSqlQueryModel::data(item, role);
}

void SqlQueryModel::setQuery ( const QSqlQuery & query )
{
	QSqlQueryModel::setQuery(query);
	info = record();
}

void SqlQueryModel::setQuery ( const QString & query, const QSqlDatabase & db)
{
	QSqlQueryModel::setQuery(query, db);
	info = record();
}
