/* 
   SQL Auditing Tools
   Copyright (C) Patrik Karlsson 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "tds.h"
#include "sqllib.h"
#include "util.h"
#include "constants.h"
#include "sqldumplogins.h"
#include <getopt.h>

void usage(char **argv) {

  printf("\n\tSQLExec %s by <patrik.karlsson@ixsecurity.com>\n",
	 SQLTOOLS_VERSION);
  printf("\t--------------------------------------------------------\n");
  printf("\t%s [options]\n\n", argv[0]);
  printf("\t\t-i*\t<ipaddress>\n");
  printf("\t\t-q\t<query> (if ommited execute interactive mode)\n");
  printf("\t\t-u\tusername\n");
  printf("\t\t-p\tpassword\n");
  printf("\n");

}


/*
  Set a few default values
*/
TDSLOGIN *set_target_defaults(TDSLOGIN *login) {

  login = tds_alloc_login();
  tds_set_passwd(login, "");
  tds_set_user(login, "sa");
  tds_set_app(login, "Microsoft Access");
  tds_set_host(login, "xxx");
  tds_set_library(login,"TDS-Library");
  tds_set_charset(login,"iso_1");
  tds_set_language(login, "us_english");
  tds_set_server(login, "");
  tds_set_packet(login, 512);
  tds_set_port(login, 1433);

  return login;

}

void doInterpret(TDSLOGIN *pLogin, char *pQuery) {

  TDSSOCKET *pTds = NULL;
  char *pCmd;

  pCmd = (char *) malloc ( 256 );
  /* connect to the SQL server */
  if( (pTds = tds_connect(pLogin)) !=NULL ) {
    fprintf(stderr, "SQLExec %s by <patrik.karlsson@ixsecurity.com>\n",
	    SQLTOOLS_VERSION);
    fprintf(stderr, "----------------------------------------------------" \
	    "----\n");

    if ( strlen(pQuery) > 0 ) {
      sqlGetResult(stdout, pTds, pQuery, 1);
      printf("\n");
    }
    else {
      for (;;) {
	memset(pCmd, 0, 256);
	printf("sqlexec> ");
	fgets(pCmd, 255, stdin);
	pCmd[strlen(pCmd)-1] = '\0';

	/* don't execute the quit */
	if ( strcmp(pCmd, "quit") == 0 || strcmp(pCmd, "\\q") == 0 )
	  break;

	if ( sqlGetResult(stdout, pTds, pCmd, 1) != TRUE )
	  printf("error performing query\n");
      }
    }

  }
  else
    fprintf(stderr, "ERROR: Login failed\n");

  free(pCmd);
}

/* Initialize all arguments */
void initArguments(ARGS *pArgs) {

  memset(pArgs->sIP, 0, sizeof(pArgs->sIP));
  pArgs->pIPFile = NULL;
  pArgs->pRepFile = NULL;
  pArgs->nLogLevel = 0;

}

int main(int argc, char **argv) {

  TDSLOGIN *pLogin;
  ARGS args;
  int c=0;
  char user[128];
  char pass[128];
  char query[1024];

  initArguments(&args);
  memset(pass, 0, sizeof(pass));
  memset(user, 0, sizeof(user));
  memset(query, 0, sizeof(query));

  while (1) {

    c = getopt (argc, argv, "i:vu:p:hq:");

    if ( c == -1 ) 
      break;

    switch (c) {

    case 'v':
      args.nLogLevel = 1;
      break;
      
    case 'u':
      strncpy(user, optarg, sizeof(user));
      break;

    case 'p':
      strncpy(pass, optarg, sizeof(pass));
      break;

    case 'q':
      strncpy(query, optarg, sizeof(query));
      break;

    case 'h':
      usage(argv);
      exit(0);
      break;

    case 'i':

      if ( ( args.pIPFile = fopen(optarg, "r") ) == NULL ) {
	
	if ( strlen(optarg) <= sizeof(args.sIP) ) {
	  strncpy(args.sIP, optarg, strlen(optarg));
	}
	else {
	  usage(argv);
	  exit(1);
	}

      }

      break;

    default:
      usage(argv);
      break;

    } /* end switch */

  } /* end while */

  /* do we have a target Roger ? */
  if ( strlen(args.sIP) == 0 && args.pIPFile == NULL ) {
    usage(argv);
    exit(1);
  }

  /* do we have a user ? */
  if ( strlen( user ) == 0 )
    strcpy(user, "sa");

  pLogin = set_target_defaults(pLogin);
  tds_set_server(pLogin, args.sIP);
  tds_set_passwd(pLogin, pass);
  tds_set_user(pLogin, user);

  doInterpret(pLogin, query);

  if ( pLogin != NULL )
    free(pLogin);

  return TRUE;
}
