/* 
   SQL Auditing Tools
   Copyright (C) Patrik Karlsson 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _SQLLIB_H
#define _SQLLIB_H

typedef struct ll_sqllogin {
  unsigned long sid;
  char name[32];
  char password[32];
  struct ll_sqllogin *next;
} SQLLOGIN;

typedef struct ll_database {
  char *dbname;
  char *dbpath;
  SQLLOGIN *pLogin;
  struct ll_database *next;
} DATABASE;

typedef struct ll_extendedSP {
  char *xspname;
  char *description;
  int  dangerous;
  struct ll_extendedSP *next;
} EXTENDEDSP;

typedef struct ll_table {
  char *tablename;
  struct ll_table *next;
} SQLTABLE;

void freeItem(DATABASE *);
DATABASE *getDatabases(TDSSOCKET *);
SQLLOGIN *getLoginsForDB(TDSSOCKET *, DATABASE *);
int createHaxorTable(TDSSOCKET *);
int dropHaxorTable(TDSSOCKET *);
int uploadFile(TDSSOCKET *, char *, char *, char *);
char *value_as_string(TDSSOCKET *,int);
int sqlExec(TDSSOCKET *,char *);
int sqlGetResult(FILE *, TDSSOCKET *, char *, int);
int dirExists(TDSSOCKET *, char *);
char *getWritableDir(TDSSOCKET *);
SQLTABLE *getTablesForDB(TDSSOCKET *, char *);
void freeTables(SQLTABLE *);
void outputExtendedStoredProcedures(FILE *, EXTENDEDSP *, int);
EXTENDEDSP* getExtendedStoredProcedures(TDSSOCKET *);
void outputTablesForDB(FILE *, SQLTABLE *, int);
int xp_dirtree(FILE *, TDSSOCKET *, char *);
void outputUsersForDB(FILE *, SQLLOGIN*);
int xp_regenumvalues(FILE *, TDSSOCKET *, char *);
char *xp_regread(FILE *, TDSSOCKET *, char *, char *);
char *getFilenameFromPath(char *);
void freeExtendedStoredProcedures(EXTENDEDSP *);
int ifExistsXP(TDSSOCKET *, char *);
int sp_addextendedproc(TDSSOCKET *, char *, char *);

#endif
