/* -*- c++ -*- */
/***************************************************************************
                         variables.h  -  description
                             -------------------
    begin                : ven mar 15 10:49:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _VARIABLES_H_
#define _VARIABLES_H_

#ifdef _WIN32
#define DIR_DELIMITER '\\'
#else
#define DIR_DELIMITER '/'
#endif

#include <cstdlib> // For the function rand.
#include <qstring.h>
#include <qdir.h>

class Object;

enum Turn { GENESTEALER_TURN, MARINE_TURN, CAT_TURN };

enum ObjectType { EXTENSIBLE, DOOR, BULKHEAD, ENTRYZONE, EXIT, FLAME, CAT, 
		  GENESTEALER, BLIP, BOLTERMARINE, SERGEANT, FLAMER,
		  NB_OBJECT_TYPE };
enum DoorState { OPEN, CLOSE };

enum historyCmd { NONE, TURN90, TURN180, FORWARD, BACKWARD, SHOOT, OVERWATCH,
		  FIRE};

enum Direction { NORTH, SOUTH, EAST, WEST, NODIRECTION };
enum FullDirection { NORTHNORTH, NORTHEAST, EASTEAST, SOUTHEAST, SOUTHSOUTH,
		     SOUTHWEST, WESTWEST, NORTHWEST };
enum RelativeDirection { FRONT, BACK, SIDE };

enum interfaceState { GUI_WAITING, GUI_SHOOT, GUI_FIRE, GUI_REVERT };

enum gameType { SOLO, HOTSEAT, PBEM, NETWORK };

struct AttackRes {
  bool attackEnable;
  int resAttack;
  Object *def;

  AttackRes(bool b, int r, Object *d) 
    : attackEnable(b), resAttack(r), def(d) {}
};

extern QString homeDir;
extern QString levelDir;

// This priority is needed for viewing on the board and in the 'onView panel'
inline int getPriority(ObjectType type)
{
  switch (type) {
  case DOOR: return 20;
  case CAT: case EXTENSIBLE: return 25;
  case GENESTEALER: case BLIP: case BOLTERMARINE: case SERGEANT: case FLAMER:
    return 30;
  case FLAME: return 50;
  case ENTRYZONE: case EXIT: return 60;
  case BULKHEAD: return 70;
  default: return 0;
  }
};

inline FullDirection Dir2FullDir(Direction dir)
{
  switch(dir) {
  case NORTH: return NORTHNORTH;
  case SOUTH: return SOUTHSOUTH;
  case WEST: return WESTWEST;
  case EAST: return EASTEAST;
  default: return NORTHNORTH;
  }
  return NORTHNORTH;
}

inline Direction FullDir2Dir(FullDirection dir)
{
  switch (dir)
    {
    case NORTHNORTH: return NORTH;
    case EASTEAST: return EAST;
    case SOUTHSOUTH: return SOUTH;
    case WESTWEST: return WEST;
    default: return NORTH;
    }
  return NORTH;
}

inline QString dir2string(Direction dir)
{
  switch(dir) {
  case NORTH: return "north";
  case SOUTH: return "south";
  case WEST: return "west";
  case EAST: return "east";
  case NODIRECTION: return "nodirection";
  }
  return "nodirection";
}

inline Direction string2dir(QString dir)
{
  if (dir=="north") return NORTH;
  else if (dir=="south") return SOUTH;
  else if (dir=="west") return WEST;
  else if (dir=="east") return EAST;
  return NODIRECTION;
}

inline QString turn2string(Turn tu)
{
  switch (tu) {
  case GENESTEALER_TURN: return "genestealer";
  case MARINE_TURN: return "marine";
  case CAT_TURN: return "cat";
  }
  return "unknown turn";
}

inline Turn string2turn(QString turn)
{
  if (turn=="genestealer") return GENESTEALER_TURN;
  else if (turn=="marine") return MARINE_TURN;
  else if (turn=="cat") return CAT_TURN;
  return MARINE_TURN;
}

inline QString type2string (ObjectType ty)
{
  switch (ty) {
  case EXTENSIBLE: return "extensible";
  case DOOR: return "door";
  case BULKHEAD: return "bulkhead";
  case ENTRYZONE: return "entry";
  case EXIT: return "exit";
  case FLAME: return "flame";
  case CAT: return "cat";
  case GENESTEALER: return "genestealer";
  case BLIP: return "blip";
  case BOLTERMARINE: return "bolter";
  case SERGEANT: return "sergeant";
  case FLAMER: return "flamer";
  default: return "Unknown object";
  }
  return "Unknow object";
}

inline ObjectType string2type (QString ty)
{
  if (ty=="extensible") return EXTENSIBLE;
  else if (ty=="door") return DOOR;
  else if (ty=="bulkhead") return BULKHEAD;
  else if (ty=="entry") return ENTRYZONE;
  else if (ty=="exit") return EXIT;
  else if (ty=="flame") return FLAME;
  else if (ty=="cat") return CAT;
  else if (ty=="genestealer") return GENESTEALER;
  else if (ty=="blip") return BLIP;
  else if (ty=="bloter") return BOLTERMARINE;
  else if (ty=="sergeant") return SERGEANT;
  else if (ty=="flamer") return FLAMER;
  return NB_OBJECT_TYPE;
}

inline QString history2string (historyCmd his)
{
  switch(his) {
  case NONE: return "none";
  case TURN90: return "turn90";
  case TURN180: return "turn180";
  case FORWARD: return "forward";
  case BACKWARD: return "backward";
  case SHOOT: return "shoot";
  case OVERWATCH: return "overwatch";
  case FIRE: return "fire";
  }
  return "none";
}

inline historyCmd string2history(QString his)
{
  if (his=="none") return NONE;
  else if (his=="turn90") return TURN90;
  else if (his=="turn180") return TURN180;
  else if (his=="forward") return FORWARD;
  else if (his=="backward") return BACKWARD;
  else if (his=="shoot") return SHOOT;
  else if (his=="overwatch") return OVERWATCH;
  else if (his=="fire") return FIRE;
  return NONE;
}

inline QString gameType2string(gameType ty)
{
  switch (ty) {
  case SOLO: return "solo";
  case HOTSEAT: return "hotseat";
  case PBEM: return "pbem";
  case NETWORK: return "network";
  }
  return "hotseat";
}

inline gameType string2gameType(QString ty)
{
  if (ty=="solo") return SOLO;
  else if (ty=="hotseat") return HOTSEAT;
  else if (ty=="pbem") return PBEM;
  else if (ty=="network") return NETWORK;
  return HOTSEAT;
}

#endif
