// -*- c++ -*-

#ifndef _SOUND_H_
#define _SOUND_H_

#include <qstring.h>

class SoundSystem
{
public:
  typedef enum
  {
    MarineDie,
    MarineMove,
    MarineShoot,
    MarineShootDoor,
    MarineAttack,
    MarineFlame,
    MarineJam,
    MarineUnjam,
    GenestealerAttack,
    GenestealerMove,
    GenestealerDie,
    BlipMove,
    DoorOpen,
    DoorClose,
    DoorDestroy,
    NbSounds
  } Sound;

  virtual ~SoundSystem() {};
  virtual void setSound(Sound event, QString filename) = 0;
  virtual void playSound(Sound event, bool wait=false) = 0;
};

extern SoundSystem *sound;

#endif
