// -*- c++ -*-
/***************************************************************************
                          sessionmanager.h  -  description
                             -------------------
    begin                : lun apr 28 15:20:00 CET 2003
    copyright            : (C) 2003 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _SESSIONMANAGER_H_
#define _SESSIONMANAGER_H_

#include "variables.h"

class GUICommandLine;
class NetworkServer;
class QDomDocument;
class QString;

class SessionManager {
 public:
  SessionManager(GUICommandLine *guicmd);

  bool NewGameStep1(void);
  bool NewGameStep2(bool filereceived=false);
  bool LoadFromFilename(const char *filename);
  bool LoadFromContent(QString &content);
  bool Load(void);
  bool Save(const char *filename);
  bool SaveRecording(void);
  bool SaveRecordingToEmail(void);
  
  bool EndOfTurn(void);

  bool Quit(void);
  void WriteOnFile(QString &content, const char *filename);
  void WriteOnEmail(QDomDocument *doc);
 private:
  GUICommandLine *guicmd;
  Turn playerTurn;
  NetworkServer *server;
};

extern SessionManager *session;

#endif 
