/****************************************************************************
** $Id: qpixmapboard.h,v 1.12 2003/09/08 13:40:04 rom_vinot Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef _QPIXMAPBOARD_H_
#define _QPIXMAPBOARD_H_

#include <qscrollview.h>
#include <qframe.h>
#include <qpixmap.h>
#include "guiboard.h"

#include "qthemeengine.h"

class QPainter;
class QCommandLine;
class BoardScrollView;

class QMiniMap : public QFrame {
  Q_OBJECT
public:
  QMiniMap(QWidget* parent, BoardScrollView* bsv);
  
  void drawContents(QPainter *p);
  void mousePressEvent(QMouseEvent* e);
  void mouseMoveEvent(QMouseEvent* e);

private:
  QThemeEngine *theme;
  BoardScrollView *bsv;
};

class QPixmapBoard : public QFrame, public GUIBoard {
  friend class QDataStoring;
    Q_OBJECT
public:
  QPixmapBoard(QScrollView* parent);
  void mouseReleaseEvent(QMouseEvent* e);
  void clicked(int x, int y, bool isLeftButton);

  void setCommandLine(QCommandLine *qcmd);
  void setMiniMap(QMiniMap *minimap);
  
  void printBoard(void);
  void Init(void);
  void switchView(void);
  void drawContents(QPainter *p);
  void drawIsometricContents(QPainter *p);

  int getZoomSize(void);

  void setYellowCases(set<int> *cases);
  void setYellowCasesFromEntryZone(void);
  void delYellowCases(void);
  void setGreenCases(set<int> *cases);
  void delGreenCases(void);

  void setKilled(int caseId, bool isMarine);
  void removeAll(void);

  QThemeEngine *getThemeEngine(void);
  QMiniMap *minimap;
private:
  QScrollView *parent;
  QThemeEngine *theme;
  bool bigpix;
  int psize, isize;

  QPixmap pixjammed_42, pixjammed_21;
  QPixmap pixoverwatch_42, pixoverwatch_21;
  QPixmap pixtaken_42, pixtaken_21;
  QPixmap pixun_42, pixun_21, pixdeux_42, pixdeux_21, pixtrois_42, pixtrois_21;
  QPixmap pixselect_42, pixselect_21;
  QPixmap pixyellow_42, pixyellow_21, pixgreen_42, pixgreen_21;

  QPixmap *pixcase, *pixjammed, *pixoverwatch, *pixtaken, 
    *pixun, *pixdeux, *pixtrois, *pixyellow, *pixgreen, *pixselect;

  QCommandLine *qcmd;

  set<int> *yellowCases;
  set<int> *greenCases;
};

class BoardScrollView : public QScrollView {
  Q_OBJECT

public:
  BoardScrollView(QWidget* parent=0, const char* name=0);
  void boardUp();
  void boardDown();
  void boardLeft();
  void boardRight();

  void switchView(void);
  void centerView(int caseId, bool force=false);

public slots:
  void alertContentsMoving(int x,int y);

 public:
  QPixmapBoard *pb;
};

#endif
