#ifndef QNEWGAMEIMPL_H
#define QNEWGAMEIMPL_H

#include "qnewgame.h"

#include "variables.h"

class QNewGameImpl : public newGameDialog
{
    Q_OBJECT

public:
    QNewGameImpl( QWidget* parent, bool *heuris,
		  gameType *gt, int *cheatProtection );
    ~QNewGameImpl();

public slots:
    void newSolo();
    void newHotseat();
    void newPBEM();
    void newNetwork();
    void toggleHeuristicTurn(bool);
    void toggleCheatEnable(bool);
    void toggleCheatPartlyEnable(bool);
    void toggleCheatDisable(bool);

private:
    bool *heuris;
    int *cheatProtection; // 1:enable, 2: partly enable, 3: disable
    gameType *type;
};

#endif // QNEWGAMEIMPL_H
