// -*- c++ -*-

#ifndef _QMYEVENT_H_
#define _QMYEVENT_H_

#include <qevent.h>
#include <qstring.h>

class WriteCustomEvent : public QCustomEvent {
 public:
  WriteCustomEvent(int type, QString msg);
  ~WriteCustomEvent();
  
  QString getMsg(void);
private:
  QString msg;
};

class ResizeCustomEvent : public QCustomEvent {
public:
  ResizeCustomEvent(int x, int y);
  ~ResizeCustomEvent();
  int getX();
  int getY();
private:
  int x;
  int y;
};

class ButtonShowHideCustomEvent : public QCustomEvent {
public:
  ButtonShowHideCustomEvent(bool vis);
  ~ButtonShowHideCustomEvent();
  bool getStatus();
private:
  bool visible;
};

class DrawInterfaceCustomEvent : public QCustomEvent {
public:
  DrawInterfaceCustomEvent(int type);
  ~DrawInterfaceCustomEvent();
  bool mustDrawAll(void);
  bool mustClearCreatureList(void);
  bool mustClearInfoPanel(void);
private:
  int type;
};

class CenterCustomEvent : public QCustomEvent {
 public:
  CenterCustomEvent(int caseId);
  ~CenterCustomEvent();
  int centerCaseId(void);
 private:
  int caseId;
};

#endif

