/***************************************************************************
                          qmain.cpp  -  description
                             -------------------
    begin                : ven avr 12 18:55:44 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef _WIN32
#pragma warning (disable : 4786)
#endif

#include <iostream>
#include <stdlib.h>
#include <algorithm>
#include <functional>

#include <qapplication.h>
#include <qdir.h>
#include <qstring.h>

#ifndef _WIN32
#include <unistd.h> // For sleep
#else
#include "zlib.h" // For Sleep
#endif

#include "qpixmapboard.h"
#include "qcommandline.h"
#include "qcreature.h"
#include "gamemanager.h"
#include "sessionmanager.h"

#include "qinterfaceimpl.h"
#include "qapplicationwindow.h"
#include "qsoundsystem.h"
#include "qdatastoring.h"

Board *board;
GameManager *man;
SoundSystem *sound;
DataStoring *store;
SessionManager *session;

#ifdef _WIN32
QString homeDir=".";
QString levelDir=".";
void GetDirFromRegistry(void);
#else
QString homeDir = QDir::homeDirPath()+"/.spacehulk";
QString levelDir = DATA_DIR;
#endif

int main( int argc, char* argv[] )
{
#ifdef _WIN32
  GetDirFromRegistry();
#endif
  
  // Create the global datastoring object to get prefs.
  store = new QDataStoring();

  // Create the window application.
  QApplication app( argc, argv );
  ApplicationWindow * mw = new ApplicationWindow();
  mw->setCaption( "QSpaceHulk - The ultimate conversion" );
  app.connect( &app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()) );
  dynamic_cast<QDataStoring*>(store)->setApp(mw);
  int x = store->getPref("window_size_width").toInt();
  int y = store->getPref("window_size_height").toInt();
  mw->resize(x,y);
  bool maximized = (store->getPref("window_maximized")=="true")?true:false;
  if (store->getPref("minimap")=="hidden")
    mw->toggleMinimap();
  
  // Create the global entity : board. 
  board = new Board();

  // Create the global entity : sound
  sound = new QtSoundSystem;

  QInterfaceImpl *main = mw->getMainWindow(); 
  QPixmapBoard *qboard = main->getPixmapBoard();
  qboard->getThemeEngine()->setTheme(store->getPref("theme").latin1());
  dynamic_cast<QDataStoring*>(store)->setBoard(qboard);

  QCreature *guic = new QCreature(main); 

  QCommandLine cmd(qboard, guic, main);
  main->setCommandLine(&cmd);
  
  session = new SessionManager(&cmd);
  man = new GameManager(guic, qboard, &cmd);
  cmd.DrawInterface();
  if (maximized) mw->showMaximized();
  else mw->show();

  if (argc==2) {
#ifdef _WIN32
    Sleep(200);
#else
    usleep(200000);
#endif
    char com[100];
    sprintf(com,"load %s",argv[1]);
    cmd.getCommand(com);
  }

  app.exec();
  cmd.endOfExecution();
  return 0;
}

#ifdef _WIN32
#include <Windows.h>
#include <Winreg.h>

void GetDirFromRegistry()
{
  HKEY hkey;
  long ret;
  char home[1024];
  DWORD size=1024;
  
  ret = RegOpenKeyEx(HKEY_CLASSES_ROOT,"QSpaceHulk",0,KEY_QUERY_VALUE, &hkey);
  if (ret != ERROR_SUCCESS)
    return;
  ret = RegQueryValueEx(hkey, "HomeDir", NULL, NULL, (LPBYTE) home, &size);
  RegCloseKey(hkey);
  homeDir = home;
  levelDir = home;
}
#endif
