#include <qlabel.h>
#include <qcheckbox.h>

#include "qdirectiondialogimpl.h"

/* 
 *  Constructs a QDirectionDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
QDirectionDialogImpl::QDirectionDialogImpl( Direction *d, bool *r, bool enableReuse, QWidget* parent,  const char* name, bool modal, WFlags fl )
  : Direction_Dialog( parent, name, modal, fl ), dir(d), reuse(r)
{
  if (!enableReuse)
    usedirection->setEnabled(false);
  *reuse = false;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
QDirectionDialogImpl::~QDirectionDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void QDirectionDialogImpl::east()
{
  *dir = EAST;
  done(0);
}
/* 
 * public slot
 */
void QDirectionDialogImpl::west()
{
  *dir = WEST;
  done(0);
}
/* 
 * public slot
 */
void QDirectionDialogImpl::north()
{
  *dir = NORTH;
  done(0);
}
/* 
 * public slot
 */
void QDirectionDialogImpl::south()
{
  *dir = SOUTH;
  done(0);
}

/* 
 * public slot
 */
void QDirectionDialogImpl::reuseToggle()
{
  *reuse = !(*reuse);
}

void QDirectionDialogImpl::setLabel(QString txt)
{
  label->setText(txt);
}

