// -*- c++ -*-
/***************************************************************************
                         object.h  -  description
                             -------------------
    begin                : ven mar 15 10:49:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* This file describes the most common method of a root class Object,
   which will be used by almost everybody.

   The class is really implemented in the creature.cpp file.
*/

#ifndef _OBJECT_H_
#define _OBJECT_H_

#include <list>
#include <set>

#include "variables.h"

using namespace std;

class GUICreature;
class GUICommandLine;
class Creature;

class Object
{
public:
  Object(GUICreature *guic, GUICommandLine *guid, int position);
  Object(const Object& copy);
  virtual ~Object(void);
  ObjectType Type(void);

  virtual Object* getCopy() const = 0;
  void setPosition(int position);
  
  int getXPosition(void);
  int getYPosition(void);
  int getPosition(void);
  int getNeighborCase(Direction dir);
  int getNeighborCaseFull(FullDirection dir);
  void getNeighbors(set<int> *ls);
  void getEmptyNeighbors(set<int> *ls);
  void getAdjacentGenestealers(set<Object *> *ls, Creature *shooter);

  virtual bool isEmpty(void);
  virtual int getId(void);
  virtual bool Open(void);
  virtual bool Close(void);
  virtual bool canBeOpened(void);
  virtual bool canBeClosed(void);
  virtual Direction getOrientation(void);
  virtual void turnOrientation(Direction dir);
  virtual bool canTurn(void);
  
  virtual bool isAttackable(void);
  virtual bool isFireable(void);
  virtual bool isShootable(void);
  virtual bool isMarinePlayer(void);
  virtual bool isSelectable(void);
  virtual bool canAttack(Direction dir);
  virtual int canBeTaken(void);
  virtual int canBeDropped(void);
  virtual int canBeTransfered(void);
  virtual int ThrowDice(bool reThrow=false, int value=0);
  virtual bool onOverwatch(void);
  virtual bool isJammed(void);
  virtual void isAttacked(void);
  virtual bool shootHasKilledObject(void);

  virtual void hasBeenTaken(void); 
  virtual void hasBeenFree(void);
  virtual bool dropTakenObject(bool fromDead=false);
  virtual bool hasAnObject(void);
  virtual void automaticTakeObject(Object *obj);

  virtual void printInfo(int loc)=0; // location is only needed for QT.
  virtual char getChar()=0;
  virtual void *getPixmap(bool big)=0;
protected:
  GUICreature *guicrea;
  GUICommandLine *guicmd;
  ObjectType type;
  int position;
};

#endif
