// -*- c++ -*-
/***************************************************************************
                          network.h  -  description
                             -------------------
    begin                : lun aug 21 15:20:00 CET 2003
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _NETWORK_H_
#define _NETWORK_H_

#include <qserversocket.h>
#include <qobject.h>

class QSocket;
class QString;
class QTextStream;

class GUICommandLine;

class NetworkServer : public QServerSocket {
 public:
  NetworkServer(GUICommandLine *guicmd);
  ~NetworkServer();

  void newConnection(int socket);
private:
  GUICommandLine *guicmd;
};

class NetworkInterface : public QObject
{
  Q_OBJECT
public:
  NetworkInterface(GUICommandLine *guicmd, int socket);
  NetworkInterface(GUICommandLine *guicmd, QString ip);
  virtual ~NetworkInterface();  

  void sendSaveGame(QString &content, bool firstgame);
  void sendCommand(QString &cmd);
  QString getFileContent(void);
private slots:
  void readyRead();
  void hostFound();
  void connected();
  void connectionClosed();
private:
  GUICommandLine *guicmd;
  QSocket *socket;
  QTextStream *stream;

  bool stateRetrieving;
  QString fileContent;
};

#endif
