// -*- c++ -*-
/***************************************************************************
                          level.h  -  description
                             -------------------
    begin                : sam avr 06 21:19:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
  Level is the main virtual class for level managing.
  All levels will inherit from this class.
*/

#ifndef _LEVEL_H_
#define _LEVEL_H_

#include <list>
#include <map>
#include <qstring.h> 

#include "object.h"
#include "levelobject.h"

using namespace std;

class GUICommandLine;
class GUICreature;
class GUIBoard;
class GUIDialog;

class LevelObject;
class LevelRef;
class LevelAction;
class LvlCond;

class Level
{
  friend class DataStoring;
public:
  QDomDocument xml;
  Level(GUICreature *guic, int *cmdPts, GUICommandLine *guicmd);
  ~Level();

  typedef map<int,Creature*>::const_iterator CreatureIterator;

  CreatureIterator beginCreature() const;
  CreatureIterator endCreature() const;
  const Creature* operator[](int caseId) const;

  bool InitFromFilename(const QString& filename, GUIBoard *board);
  bool InitFromContent(const QString& content, GUIBoard *board);
  bool InitFromSaveGame(QDomElement &xml);

  void InitMarine();
  void InitGenestealer();
  bool isInitMarineNull();
  bool isInitGenestealerNull();
  bool BeginMarineTurn();
  bool BeginGenestealerTurn();
  bool getFirstWinCheckerIsMarine();
  bool getFirstPlayerIsMarine();
  bool EndMarineTurn(void);
  bool EndGenestealerTurn(void);
  bool EndDrawTurn(void);

  QString getMessage(void);
  void getLevelInfo(QString &title, QString &auth, QString &nar, QString &obj,
		    QString &forc, QString &cond);
  LevelRef* getRef(const QString& name);
  void setRef(LevelRef* ref);
  void clearRef(const QString& name);
  void killed(ObjectType type);
  int getNbKilled(ObjectType type);
  set<int> * getObjectiveCases(void);


  bool IsOnFire(int caseId);
  //bool IsBlocked(int caseId);
  //bool IsOpen(int caseId);

  bool& getCond(QString name);
  int& getValue(QString name);

  void removeAll(void);

  int *CmdPts;
  GUICreature *guiCreature;
  GUICommandLine *guiCmdLine;

protected:
  std::map<QString,LevelRef*> name_table;
  QDomElement level, map, marine_cfg, genestealer_cfg, global, turnmsg;
  QString title, author, narration, objectives, forces, conditions;
  void CreateMap(GUICreature *guic, GUICommandLine *guicmd);
  void StepTeam(list<LevelAction*> &steps);
  void ExecuteAction(LevelAction *action);
  list<LevelAction*> init_alien, init_marine;
  list<LevelAction*> begin_alien, begin_marine;
  LvlCond *winner_marine, *winner_alien, *winner_draw;
  bool firstWinCheckerIsMarine;
  bool firstPlayerIsMarine;
  std::map<QString,bool> cond_table;
  std::map<QString,int> value_table;

  set<int> objectiveCases;
  std::map<int,int> num_killed;
};

class LevelAction
{
public:
  static void BuildActions(list<LevelAction*> &list, const QDomElement &node, Level *l);
  LevelAction(const QDomElement &base, Level *l);
  void Execute();
  QDomElement todo;
  LvlCond *cond;
  Level *level;
};

#endif
