// -*- c++ -*-
/***************************************************************************                          guicommandline.h  -  description
                             -------------------
    begin                : jeu avr 18 16:56:00 CET 2002
    copyright            : (C) 2002 by Romain Vinot
    email                : vinot@aist.enst.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _GUICOMMANDLINE_H_
#define _GUICOMMANDLINE_H_

/*
  CommandLine is the GUI interface for player interaction.
  This class takes all the input of the player and if it's a command execute it

  This class is a virtual one. It must be inherited from xcommandline or 
  qcommandline.
*/

#include <set>
#include <qstring.h>
using namespace std;


#include "variables.h"

class Board;
class GameManager;
class GUICreature;
class GUIBoard;
class DataStoring;

struct SmtpInfo {
  QString smtp;
  QString yourEmail;
  QString opponentEmail;
  QString playermsg;
  QString port;
  bool useAuth;
  QString login;
  QString password;
};

class GUICommandLine
{
public:
  GUICommandLine(GUIBoard *board, GUICreature *guicrea);
  virtual ~GUICommandLine(void);
  
  virtual void endOfExecution(void)=0;

  QString getPreviousCommand(void);

  virtual void commandNewGame(QString &command);
  virtual QString commandView(QString &command);
  virtual QString commandSelect(QString &command);
  virtual QString commandMove(QString &command);
  virtual QString commandEnter(QString &command);
  virtual QString commandRevert(QString &command);
  virtual QString commandTurn(QString &command);
  virtual QString commandOpen(QString &command);
  virtual QString commandClose(QString &command);
  virtual QString commandAttack(QString &command);
  virtual QString commandShoot(QString &command);
  virtual QString commandFire(QString &command);
  virtual QString commandStop(QString &command);
  virtual QString commandUnjam(QString &command);
  virtual QString commandLoadFlamer(QString &command);
  virtual QString commandOverwatch(QString &command);
  virtual QString commandTakeOrDrop(QString &command);
  virtual QString commandEndTurn(QString &command);
  virtual QString commandSave(QString &command);
  virtual QString commandLoad(QString &command);
  virtual QString commandMessage(QString &command);
  virtual QString commandConnect(QString &command);
  virtual QString commandRecord(QString &command);
  virtual QString commandUndo(QString &command);
  virtual QString commandNetwork(QString &command);
  virtual QString commandHelp(QString &command);

  virtual pair<Direction,bool> GetDirection(QString txt,bool enabReuse=true)=0;
  virtual QString GetLevelToPlay()=0;
  virtual pair<int,pair<Direction,bool> > 
    GetCaseAndDirection(set<int> *cas, QString txt, bool enableReuse=true)=0;
  virtual int GetCase(set<int> *cases, QString txt)=0;
  virtual bool GetYesOrNo(QString txt)=0;
  virtual gameType GetGameType(bool *heurTurn, int *cheat)=0;
  virtual QString GetFilename(bool PbemExt=false)=0;
  virtual void GetSmtpInfos(SmtpInfo *inf)=0;
  virtual QString GetIPAdress()=0;
  virtual void endOfGame(QString msg)=0;
  virtual void CenterView(int caseId)=0;
  virtual void PostNetworkCommand()=0;
  virtual void GetNetworkCommand()=0;

  FullDirection getDirectionType(char *d);

  virtual void printLevelInfo(QString &tit, QString &auth, QString &nar,
			      QString &obj, QString &forc, QString &cond)=0;
  virtual void printLevelInfo(void)=0;
  virtual void Write(QString w, bool isCommand=false)=0;
  virtual void DrawInterface(void)=0;
  virtual void ClearListCreatures(void)=0;
  virtual void printPopupMessage(QString msg)=0;
  virtual void ClearInfoPanel(void)=0;

  virtual void getCommand(QString command);
  virtual void getReplayCommand(QString command);
  virtual bool getMainCommands(QString command); 
  virtual void getAllCommands(QString command);
  virtual void getShootingCommand(QString command);
  virtual void getFiringCommand(QString command);

  void setState(interfaceState s);

  virtual void setObjectButtonsVisible(bool vis)=0;
protected:
  GUIBoard *guiboard;
  GUICreature *guicrea;
  
  interfaceState state;

  QString previous;
};

#endif
