%{
/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

int lineno = 1 ; /* number of scanned lines */
char linebuf[1024] ; /* current code line in the source */
int tokenpos = 0 ; /* current token position in the current line */

#include "tags.h"
#include "tokens.h"
#include "colors.h"

#include "genfun.h"

%}

ws [ ]+
tabs [\t]+

nl \n
cr \r
IDE [a-zA-Z_]([a-zA-Z0-9_])*
wspace [ \t\n\r]

STRING \"[^\"\n]*\"

not_alpha [^a-zA-Z0-9]

%s COMMENT_STATE
%s SINGLELINE_COMMENT
%s STRING_STATE
%s CHAR_STATE

symbol [\~\!\%\^\*\(\)\-\+\=\[\]\|\\\:\;\,\.\/\?\&\<\>]
funccall {IDE}/{wspace}*\(

%%



\r {}

<INITIAL>"/*" { BEGIN COMMENT_STATE ;
 startComment( yytext ) ;      
}
<INITIAL>"/*".*"*/" { generateComment( yytext ) ;  }


<COMMENT_STATE>\n { 
   endComment (""); 
   ++lineno;
   generateNewLine() ;
   startComment ("");
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }
<COMMENT_STATE>"*/" { endComment(yytext) ;
                      BEGIN INITIAL ; /* end of the comment */ }

<INITIAL>"//" { BEGIN SINGLELINE_COMMENT ; startComment( yytext ) ; }
<SINGLELINE_COMMENT>\n { 
   BEGIN INITIAL ;
   yyless (0); // put the \n back
   endComment( yytext ) ; 
   /* if we encounter another // during a comment we simply
      treat it as a ordinary string */
 }

<INITIAL>\" { BEGIN STRING_STATE ; startString( yytext );  }
<STRING_STATE>\\\\ {  generate_preproc( yytext ) ; }
<STRING_STATE>"\\\"" {  generate_preproc( yytext ) ; }
<STRING_STATE>\" { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>\' { BEGIN CHAR_STATE ; startString( yytext );  }
<CHAR_STATE>\\\\ {  generate_preproc( yytext ) ; }
<CHAR_STATE>"\\\'" {  generate_preproc( yytext ) ; }
<CHAR_STATE>\' { BEGIN INITIAL ; endString( yytext ) ; }

<INITIAL>abstract |
<INITIAL>break |
<INITIAL>case |
<INITIAL>catch |
<INITIAL>class |
<INITIAL>const |
<INITIAL>continue |
<INITIAL>default |
<INITIAL>do |
<INITIAL>else |
<INITIAL>extends |
<INITIAL>final |
<INITIAL>finally |
<INITIAL>for |
<INITIAL>goto |
<INITIAL>if |
<INITIAL>implements |
<INITIAL>instanceof |
<INITIAL>interface |
<INITIAL>native |
<INITIAL>new |
<INITIAL>null |
<INITIAL>package |
<INITIAL>private |
<INITIAL>protected |
<INITIAL>public |
<INITIAL>return |
<INITIAL>static |
<INITIAL>super |
<INITIAL>switch |
<INITIAL>synchronized |
<INITIAL>throw |
<INITIAL>throws |
<INITIAL>this |
<INITIAL>transient |
<INITIAL>try |
<INITIAL>volatile |
<INITIAL>while  { generateKeyWord( yytext ) ; }


<INITIAL>int |
<INITIAL>byte |
<INITIAL>boolean |
<INITIAL>char |
<INITIAL>long |
<INITIAL>float |
<INITIAL>double |
<INITIAL>short |
<INITIAL>void { generateBaseType( yytext ) ; }

<INITIAL>0[xX][0-9a-fA-F]* { generateNumber( yytext ) ; }
<INITIAL>[0-9][0-9]*(\.[0-9]*[eE]?[-+]?[0-9]*)? { generateNumber( yytext ) ; }

<INITIAL>{symbol} { generateSymbol( yytext ); }
<INITIAL>[\{\}] { generateCBracket ( yytext ); }
<INITIAL>{funccall} { generateFunction ( yytext ); }

<INITIAL>import { generatePreProc( yytext) ; }

<INITIAL>[a-zA-Z_]([a-zA-Z0-9_])* { generate_normal( yytext ) ; }

\t {
        generateTab() ;
}

. { generate_preproc( yytext ) ; /* anything else */ }

\n { 
       ++lineno;
       generateNewLine() ;
}

%%

void yyerror( char *s ) ;

void yyerror( char *s )
{  
  fprintf( stderr, "%d: %s: %s\n%s\n", lineno, s, yytext, linebuf ) ;
  fprintf( stderr, "%*s\n", tokenpos, "^" ) ;
}
