/* Snownews - A lightweight console RSS newsreader
 * 
 * Copyright 2003 Oliver Feiler <kiza@kcore.de>
 * http://kiza.kcore.de/software/snownews/
 *
 * updatecheck.c
 *
 * This file contains all code that us executed for the auto version
 * check function. Nothing else besides SYN packets and a HTTP GET
 * is sent to my webserver. ;)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* Contains duplicate code from netio.c.
 *
 * This function does not care for any errors that occured while
 * connecting and transferring data. If something didn't work, just
 * return and don't bother the user anymore.
 */
 
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>

#include "config.h"
#include "version.h"

extern char *proxyname;				/* Hostname of proxyserver. */
extern unsigned short proxyport;	/* Port on proxyserver to use. */
extern char *useragent;

void AutoVersionCheck (void) {
	int result;
	int my_socket;
	char netbuf[4096];
	struct sockaddr_in address;
	struct hostent *remotehost;
	FILE *stream;
	FILE *lastupdated;
	char file[512];
	char timestring[21];	/* Should be enough for 64bit systems. */
	char oldtimestring[21];
	int oldtime;
	
	/* We check once a week. */
	snprintf (timestring, sizeof(timestring), "%d", (int) time(NULL));
	snprintf (file, sizeof(file), "%s/.snownews/updatecheck", getenv("HOME"));
	lastupdated = fopen (file, "r+");
	if (lastupdated == NULL) {
		lastupdated = fopen (file, "w+");
		fputs (timestring, lastupdated);
		fclose (lastupdated);
	} else {
		fgets (oldtimestring, sizeof(oldtimestring), lastupdated);
		oldtime = atoi(oldtimestring);
		if ((((int) time(NULL))-oldtime) < 604800) {
			/* Less than one week. */
			fclose (lastupdated);
			return;
		} else {
			rewind (lastupdated);
			fputs (timestring, lastupdated);
			fclose (lastupdated);
		}
	}
		
	
	/* Create an inet stream TCP socket. */
	my_socket = socket (AF_INET, SOCK_STREAM, 0);
	if (my_socket == -1) {
		return;
	}
	
	/* If proxyport is 0 we didn't execute the if http_proxy statement in main
	   so there is no proxy. On any other value of proxyport do proxyrequests instead. */
	if (proxyport == 0) {
		/* Lookup remote IP. */
		remotehost = gethostbyname ("home.kcore.de");
		if (remotehost == NULL) {
			return;
		}
		
		/* Set the remote address. */
		address.sin_family = AF_INET;
		address.sin_port = htons(80);
		memcpy (&address.sin_addr.s_addr, remotehost->h_addr_list[0], remotehost->h_length);
		
		/* Connect socket. */
		result = connect (my_socket, (struct sockaddr *) &address, sizeof(address));
		if (result != 0) {
			return;
		}
	} else {
		/* Lookup remote IP. */
		remotehost = gethostbyname (proxyname);
		if (remotehost == NULL) {
			return;
		}
		
		/* Set the remote address. */
		address.sin_family = AF_INET;
		address.sin_port = htons(proxyport);
		memcpy (&address.sin_addr.s_addr, remotehost->h_addr_list[0], remotehost->h_length);
		
		/* Connect socket. */
		result = connect (my_socket, (struct sockaddr *) &address, sizeof(address));
		if (result != 0) {
			return;
		}
	}

	/* Open socket. */	
	stream = fdopen (my_socket, "r+");
	if (stream == NULL) {
		return;
	}
	
	/* Again is proxyport == 0, non proxy mode, otherwise make proxy requests. */
	if (proxyport == 0) {
		/* Request URL from HTTP server. */
		fprintf(stream, "GET /~kiza/software/snownews/version HTTP/1.0\r\nUser-Agent: %s\r\nConnection: close\r\nHost: home.kcore.de\r\n\r\n", useragent);
	} else {
		fprintf(stream, "GET http://home.kcore.de/~kiza/software/snownews/version HTTP/1.0\r\nUser-Agent: %s\r\nConnection: close\r\nHost: home.kcore.de\r\n\r\n", useragent);
	}
	
	/* fflush()ing is needed on Solaris. */
	fflush(stream);

	/* Read rest of HTTP header and... throw it away. */
	while (!feof(stream)) {
		/* Max line length of sizeof(netbuf) is assumed here.
		   If header has longer lines than 4096 bytes something may go wrong. :) */
		if ((fgets (netbuf, sizeof(netbuf), stream)) == NULL)
			break;
		if (strstr (netbuf, "chunked") != NULL) {
			/* Server sent junked encoding. We didn't request this. Bh! */
			fclose (stream);
			return;
		}
		if (strcmp(netbuf, "\r\n") == 0)
			break;
	}

	/* The following line is either the version number or crap we don't need. */
	if ((fgets (netbuf, sizeof(netbuf), stream)) == NULL) {
		fclose (stream);
		return;
	}
	if (netbuf[strlen(netbuf)-1] == '\n')
		netbuf[strlen(netbuf)-1] = '\0';
		
	if (strcmp(netbuf, VERSION) != 0) {
		printf (_("A new version %s of Snownews is available.\n"), netbuf);
		printf (_("If you want to download it, go to http://kiza.kcore.de/software/snownews/\n\n"));
		printf (_("To disable the auto version check see the manpage.\n\n"));
	}

	fclose (stream);
	return;
}
