#ifndef SNCON_H
#define SNCON_H
#include "../snort.h"
#include <ncurses.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "libiap/iap.h"

#if TCPWRAPPERS
#include <tcpd.h>

int             allow_severity;
int             deny_severity;
#endif				/* TCPWRAPPERS */



#ifndef VERSION
#define VERSION "0.1"
#endif				/* othervise defined with -DVERSION */
#define SNBANNER "SnortMaster v."VERSION
typedef struct _cltnode {
	unsigned long   id; // reported sensor ID
	unsigned long   pid; // PID of the serving process
	unsigned long   addr; // remote IP address
	unsigned long   from; // connected from (should not be different
			     // from addr until connected through a proxy
	int pipe[2];
	struct _cltnode *next;
	struct _cltnode *prev;
} cltnode;

typedef struct _alertnode {
	NetAlert alert;
	struct sockaddr_in clt;
	struct _alertnode *next;
	} alertnode;


/* local includes for prototypes */
#include "snortnet.h"
#include "ncursed.h"
#include "utils.h"
#include "sigs.h"

/* defines */

#define SN_IO_ERROR 1
#define SN_PROTOCOL_ERROR 2


/* PROTOTYPES */
int             bind_socket(int);
int             serve(int, struct sockaddr_in *, cltnode *);
int accept_connection(int );
#endif				/* SNCON_H */
