<?php
/*
** Copyright (C) 2000 Carnegie Mellon University
**
** Authors: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*  
 * Analysis Console for Incident Databases (ACID) by Roman Danyliw
 *
 * This application was developed at the CERT Coordination Center as a part 
 * of the AIRCERT project.
 *
 * See http://www.cert.org/kb/acid for the most up to date 
 * information and documentation about this application.
 *
 * Purpose:
 *
 *   ACID is an PHP-based analysis engine to search and process 
 *   a database of security incidents generated by the NIDS Snort.
 *
 * Configuration:
 *
 *   See the 'README' file, and 'acid.conf'
 *
 */
?>
<?php
  include("acid_conf.php");
  include("acid_db.inc");
  include("acid_common.php");
  include("acid_stat_common.php");
  include("acid_db_common.php");

  RegisterGlobalState();
  InitGlobalState();
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>

<HEAD>

  <META name="Author" content="Roman Danyliw">
  <META HTTP-EQUIV="pragma" CONTENT="no-cache">
  <?php
    PrintFreshPage($refresh_stat_page, $stat_page_refresh_time);
  ?>
  <TITLE>Analysis Console for Intrusion Databases (ACID) </TITLE>

  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader"> &nbsp </TD>
  <TD class="mainheadertitle">
     <U>A</U>nalysis <U>C</U>onsole for <U>I</U>ntrusion <U>D</U>atabases
  </TD>
</TR>
</TABLE>
<P><P>

<?php

  if ( $debug_mode == 1 )
     PrintPageHeader();

  /* Check that PHP was built correctly */
  $tmp_str = verify_php_build($DBtype);
  if ( $tmp_str != "")
  {
     echo $tmp_str;
     die();
  }

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  /* Check that the DB schema is recent */
  $tmp_str = verify_db($db, $alert_dbname, $alert_host);
  if ( $tmp_str != "")
  {
     echo $tmp_str;
     die();
  }

  printf("<B>Queried on </B><FONT> : %s<BR>",date("D F d, Y H:i:s",time()));
  printf("<B>Database:</B> %s &nbsp;&nbsp;&nbsp;(<B>schema version:</B> %d) \n<BR>\n", 
         ($alert_dbname.'@'.$alert_host. ($alert_port != "" ? ':'.$alert_port : "") ),
         db_schema_version($db) );
  StartStopTime($start_time, $end_time, $db);
  if ( $start_time != "" )
     printf("<B>Time window:</B> [%s] - [%s]\n<P>\n", $start_time, $end_time);
  else
     printf("<B>Time window:</B> <I>no alerts detected</I>\n");

  echo '<TABLE BORDER=1 WIDTH="100%">
        <TR>
           <TD WIDTH="30%" VALIGN=TOP>';
	     echo '<BR><B># of Sensors:</B>
                      <A HREF="acid_stat_sensor.php">'.SensorCnt($db).'</A>';
             echo '<P><B>Unique Alerts:</B> <A HREF="acid_stat_alerts.php">'.UniqueAlertCnt($db).'</A><BR>';
             echo '<B>Total Number of Alerts:</B> 
                      <A HREF="acid_pkt_main.php?&num_result_rows=-1'.
                             '&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                             '&submit=Query+DB&current_view=-1">'.EventCnt($db).'</A>';

             echo '<UL><LI>Source IP addresses: '. 
                       BuildUniqueAddressLink(1).
                        UniqueSrcIPCnt($db).'</A>'.
                      '<LI>Dest. IP addresses: '.
                       BuildUniqueAddressLink(2).
                       UniqueDstIPCnt($db).'</A>
                   </UL>';
  echo '   </TD>
           <TD WIDTH="70%">
             <B>Traffic Profile by Protocol</B>';
             PrintProtocolProfileGraphs($db);

  echo '   </TD>
        </TR>
        </TABLE>';
?>

<P>
<LI><B><A HREF="acid_pkt_main.php?new=1">Search</A></B>
<LI><B><A HREF="acid_graph_main.php">Graph Alert data</A></B>&nbsp;(<FONT COLOR="#FF0000">EXPERIMENTAL</FONT>)

<P>
<LI><B>Snapshot</B>
<UL>
<?php
   $tmp_month = date("m");
   $tmp_day = date("d");
   $tmp_year = date("Y");

   $yesterday_year = date("Y", time()-86400);
   $yesterday_month = date("m", time()-86400);
   $yesterday_day = date ("d", time()-86400);
   $yesterday_hour = date ("H", time()-86400);

   $tmp_24hour = 'acid_pkt_main.php?new=1&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=%3E%3D'.
                                 '&time%5B0%5D%5B2%5D='.$yesterday_month.
                                 '&time%5B0%5D%5B3%5D='.$yesterday_day.
                                 '&time%5B0%5D%5B4%5D='.$yesterday_year.
                                 '&time%5B0%5D%5B5%5D='.$yesterday_hour.
                                 '&time%5B0%5D%5B6%5D=&time%5B0%5D%5B7%5D='.
                                 '&time%5B0%5D%5B8%5D=+&time%5B0%5D%5B9%5D=+'.
                                 '&submit=Query+DB&num_result_rows=-1&time_cnt=1';
   $tmp_24hour_unique = 'acid_stat_alerts.php?'.
                                 'time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=%3E%3D'.
                                 '&time%5B0%5D%5B2%5D='.$yesterday_month.
                                 '&time%5B0%5D%5B3%5D='.$yesterday_day.
                                 '&time%5B0%5D%5B4%5D='.$yesterday_year.
                                 '&time%5B0%5D%5B5%5D='.$yesterday_hour.
                                 '&time%5B0%5D%5B6%5D=&time%5B0%5D%5B7%5D='.
                                 '&time%5B0%5D%5B8%5D=+&time%5B0%5D%5B9%5D=+'.
                                 '&time_cnt=1';

   $tmp_today = 'acid_pkt_main.php?new=1'.
                                 '&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=%3D'.
                                 '&time%5B0%5D%5B2%5D='.$tmp_month.
                                 '&time%5B0%5D%5B3%5D='.$tmp_day.
                                 '&time%5B0%5D%5B4%5D='.$tmp_year.
                                 '&time%5B0%5D%5B5%5D=&time%5B0%5D%5B6%5D=&time%5B0%5D%5B7%5D='.
                                 '&time%5B0%5D%5B8%5D=+&time%5B0%5D%5B9%5D=+'.
                                 '&submit=Query+DB&num_result_rows=-1&time_cnt=1';

  $tmp_today_unique = 'acid_stat_alerts.php?'.
                                 'time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=%3D'.
                                 '&time%5B0%5D%5B2%5D='.$tmp_month.
                                 '&time%5B0%5D%5B3%5D='.$tmp_day.
                                 '&time%5B0%5D%5B4%5D='.$tmp_year.
                                 '&time%5B0%5D%5B5%5D=&time%5B0%5D%5B6%5D=&time%5B0%5D%5B7%5D='.
                                 '&time%5B0%5D%5B8%5D=+&time%5B0%5D%5B9%5D=+'.
                                 '&time_cnt=1';

  echo '
  <LI>Today\'s  <A HREF="'.$tmp_today_unique.'">Unique alerts</A>, 
                <A HREF="'.$tmp_today.'">Alert list</A>
  <LI>Last 24 Hours <A HREF="'.$tmp_24hour_unique.'">Unique alerts</A>,
                <A HREF="'.$tmp_24hour.'">Alert List</A>';
?>
  <LI>Most <A HREF="acid_stat_alerts.php?caller=last_alerts&sort_order=last_d">
       recent <?php echo $last_num_ualerts; ?> Unique Alerts</A>
  <LI>Most <A HREF="acid_stat_alerts.php?caller=most_frequent&sort_order=occur_d">
       frequent <?php echo $freq_num_alerts; ?> Alerts</A>

  <LI>Most frequent <?php echo $freq_num_uaddr; ?> addresses:
      <A HREF="acid_stat_uaddr.php?caller=most_frequent&addr_type=1&sort_order=occur_d">source</A>, 
      <A HREF="acid_stat_uaddr.php?caller=most_frequent&addr_type=2&sort_order=occur_d">destination</A>

  <LI>Most recent <?php echo $last_num_alerts; ?> Alerts:
      <A HREF="acid_pkt_main.php?new=1&caller=last_any&num_result_rows=-1&submit=Last%20Any">any protocol</A>,  
      <A HREF="acid_pkt_main.php?new=1&layer4=TCP&caller=last_tcp&num_result_rows=-1&submit=Last%20TCP">TCP</A>,
      <A HREF="acid_pkt_main.php?new=1&layer4=UDP&caller=last_udp&num_result_rows=-1&submit=Last%20UDP">UDP</A>,
      <A HREF="acid_pkt_main.php?new=1&layer4=ICMP&caller=last_icmp&num_result_rows=-1&submit=Last%20ICMP">ICMP</A>

  <P>
  <LI>Graph alert <A HREF="acid_stat_time.php">detection time</A> 
</UL>

<FONT>
<P>
<LI><B>Alert Group (AG) <A HREF="acid_ag_main.php?ag_action=list">maintenance</A></B>

</FONT>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>





