/* $Id: debug.h,v 1.9.4.1 2002/03/15 14:42:30 chrisgreen Exp $ */
/*
** Copyright (C) 1998-2002 Martin Roesch <roesch@sourcefire.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef DEBUG_H
#define DEBUG_H

#include "snort.h"


#define DEBUG_VARIABLE "SNORT_DEBUG"

#define DEBUG_ALL             0xffff
#define DEBUG_INIT            0x00000001
#define DEBUG_CONFIGRULES     0x00000002
#define DEBUG_PLUGIN          0x00000004
#define DEBUG_DATALINK        0x00000008
#define DEBUG_IP              0x00000010
#define DEBUG_TCPUDP          0x00000020
#define DEBUG_DECODE          0x00000040
#define DEBUG_LOG             0x00000080
#define DEBUG_MSTRING         0x00000100
#define DEBUG_PARSER          0x00000200
#define DEBUG_PLUGBASE        0x00000400
#define DEBUG_RULES           0x00000800
#define DEBUG_FLOW            0x00001000
#define DEBUG_STREAM          0x00002000
#define DEBUG_PATTERN_MATCH   0x00004000


#ifdef DEBUG

    extern char *DebugMessageFile;
    extern int DebugMessageLine;

    #define    DebugMessage    DebugMessageFile = __FILE__; DebugMessageLine = __LINE__; DebugMessageFunc

    void DebugMessageFunc(int , char *, ...);

    int GetDebugLevel (void);

#else 

#ifdef WIN32
         /* Visual C++ uses the keyword "__inline" rather than "__inline__" */
         #define __inline__ __inline
#endif


static __inline__ void DebugMessage(int dbg,char *fmt, ...) {}

#endif /* DEBUG */


#endif /* DEBUG_H */
