/*
** Copyright (C) 1998,1999,2000,2001 Martin Roesch <roesch@clark.net>
** Copyright (C) 1999,2000,2001 Christopher E. Cramer <cec@ee.duke.edu>
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* Snort TCP Stream Reconstruction Plugin v2
   by Christopher E. Cramer <cec@ee.duke.edu>
*/

/* $Id: spp_tcp_stream2.h,v 1.6 2001/05/08 19:10:04 roesch Exp $ */

#include "snort.h"

#ifndef __SPP_TCP_STREAM2_H__
#define __SPP_TCP_STREAM2_H__

#define CLOSED       0
#define LISTEN       1
#define SYN_RCVD     2
#define SYN_SENT     3
#define ESTABLISHED  4
#define CLOSE_WAIT   5
#define LAST_ACK     6
#define FIN_WAIT_1   7
#define CLOSING      8
#define FIN_WAIT_2   9
#define TIME_WAIT   10

#define COLLECT_CLIENT 0x01
#define COLLECT_SERVER 0x02

typedef struct _TcpStream2PacketData
{
    u_char *data;
    u_long seq;
    u_long size;
    int lfcr;
    struct _TcpStream2PacketData *next;
} TcpStream2PacketData;

typedef struct _TcpStream2Session
{
    u_long sip,cip;  /* can be found in p->iph->ip_src.s_addr */
    u_int16_t sp, cp;
    int client_status, server_status;
    u_long c_first_seq;
    u_long s_first_seq;
    u_long c_last_ack;
    u_long s_last_ack;
    u_long s_win;
    u_long c_win;
    TcpStream2PacketData *c_data, *s_data;
    struct _TcpStream2Session *next;
    u_long timestamp;
} TcpStream2Session;

typedef struct _TcpStream2Data
{
    int ports[32];   /* 32 is kind of arbitrary */
    u_char port_collect[32];
    int num_entries;
    TcpStream2Session * heads[256];
    u_char trunc;
    u_long timestamp;
    u_long prunetime;
    u_long maxbytes;
    u_long minbytes;
} TcpStream2Data;

/* list of function prototypes for this preprocessor */
void SetupTcpStream2();
void TcpStream2Init(u_char *);
void ParseTcpStream2Args(char *);
void TcpStream2Packet(Packet *);
u_long TcpStream2Time();
TcpStream2Session * TcpStream2CheckSession(Packet *, int, int * );
void TcpStream2PruneSessions();
void TcpStream2Commit(TcpStream2Session *, int );
void TcpStream2Packetize(TcpStream2Session *, Packet *, u_long , int);
void TcpStream2Exit(int signal, void *arg);
void TcpStream2Restart(int signal, void *arg);
u_long TcpStream2FillBuffer(TcpStream2Session *, u_char *, u_long, int);
void TcpStream2Packetize(TcpStream2Session *, Packet *, u_long, int);
void TcpStream2StoreData( TcpStream2Session *, Packet *, int);
u_long TcpStream2CheckAck(TcpStream2Session *, u_long, int);
u_long TcpStream2DataSize(TcpStream2Session *, int);
void TcpStream2PrintDataList(TcpStream2Session *, int);


#endif  /* __SPP_TCP_STREAM2_H__ */
