/*
** Copyright (C) 2001 Jeff Nathan <jeff@wwti.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: spp_arpspoof.h,v 1.2 2001/07/25 05:26:47 roesch Exp $ */
/* Snort ARPspoof Preprocessor Plugin
*   by Jeff Nathan <jeff@wwti.com>
*   Version 0.1.0
*/

#include "snort.h"

#ifndef __SPP_ARPSPOOF_H__
#define __SPP_ARPSPOOF_H__

typedef struct _IPMacEntry
{
	u_int32_t ipv4_addr;
	u_int8_t  mac_addr[6];
	u_int8_t  pad[2];
} IPMacEntry;

typedef struct _IPMacEntryListNode
{
	IPMacEntry *ip_mac_entry;
	struct _IPMacEntryListNode *next;
} IPMacEntryListNode;

typedef struct _IPMacEntryList
{
	int size;
	IPMacEntryListNode *head;
	IPMacEntryListNode *tail;
} IPMacEntryList;

int AddIPMacEntryToList(IPMacEntryList *ipmel, IPMacEntry *ipme);
IPMacEntry *LookupMacEntryByIP(IPMacEntryList *ipmel, u_int32_t ipv4_addr);
void FreeIPMacEntryList(IPMacEntryList *ipmel);

/* list of function prototypes for this preprocessor */
void SetupARPspoof();
void ARPspoofInit(u_char *);
void ParseARPspoofArgs(char *);
void ARPspoofPreprocFunction(Packet *);
void ARPspoofRestartFunction(int);
void ARPspoofCleanExitFunction(int);
void ARPwatchArg(u_char *);

#endif  /* __SPP_ARPSPOOF_H__ */
