/*
** Copyright (C) 1998,1999,2000,2001 Martin Roesch <roesch@clark.net>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: spo_unified.h,v 1.2 2001/06/24 02:47:19 roesch Exp $ */

#include "snort.h"

#ifndef __SPO_UNIFIED_H__
#define __SPO_UNIFIED_H__

#define SNORT_MAGIC     0xa1b2c3d4
#define SNORT_VERSION_MAJOR   1
#define SNORT_VERSION_MINOR   2

typedef struct _UnifiedData
{
    char *log_filename;
    char *alert_filename;
    FILE *log;
    FILE *alert;
    int log_written;

} UnifiedData;



/* file header for snort unified format log files
 *
 * Identical to pcap file header, used for portability where the libpcap
 * might not be used after the pa_engine code becomes available
 */ 
typedef struct _UnifiedLogFileHeader
{
    u_int32_t magic;
    u_int16_t version_major;
    u_int16_t version_minor;
    u_int32_t timezone;
    u_int32_t sigfigs;
    u_int32_t snaplen;
    u_int32_t linktype;
} UnifiedLogFileHeader;



typedef struct _UnifiedAlertFileHeader
{
    u_int32_t magic;
    u_int32_t version_major;
    u_int32_t version_minor;
    u_int32_t timezone;
} UnifiedAlertFileHeader;


/* unified log packet header format 
 *
 * One of these per packet in the log file, the packets are appended in the 
 * file after each UnifiedLog header (extended pcap format) 
 */ 
typedef struct _UnifiedLog
{
    Event event;
    u_int32_t flags;       /* bitmap for interesting flags */
    SnortPktHeader pkth;   /* SnortPktHeader schtuff */
} UnifiedLog;


/* Unified alert message format
 *
 * One per event notification, all the important data for people to know
 */ 
typedef struct _UnifiedAlert
{
    Event event;
    struct timeval ts;         /* event timestamp */
    u_int32_t sip;             /* src ip */
    u_int32_t dip;             /* dest ip */
    u_int16_t sp;              /* src port */
    u_int16_t dp;              /* dest port */
    u_int32_t protocol;        /* protocol id */
    u_int32_t flags;           /* any other flags (fragmented, etc) */
} UnifiedAlert;

/* list of function prototypes for this preprocessor */
void SetupUnified();
void UnifiedLogInit(u_char *);
void UnifiedAlertInit(u_char *);
void ParseUnifiedLogArgs(char *);
void ParseUnifiedAlertArgs(char *);
void LogUnified(Packet *, char *, void *, Event *);
void AlertUnified(Packet *, char *, void *, Event *);
void UnifiedInitLogFile(UnifiedData *);
void UnifiedInitAlertFile(UnifiedData *);
void SpoUnifiedLogCleanExitFunc(int, void *);
void SpoUnifiedLogRestartFunc(int, void *);
void SpoUnifiedAlertCleanExitFunc(int, void *);
void SpoUnifiedAlertRestartFunc(int, void *);

#endif  /* __SPO_UNIFIED_H__ */
