#!/usr/bin/perl -w

# This script opens the file specified by it's argument and appends an idmef
# keyword tag to the end of each rule.  If the rule has WEB, ColdFusion,
# FrontPage, or IIS in it, the idmef type is web.  Otherwise, it's default.

$rules_file = $ARGV[0];

if($rules_file eq "") {
  die "USAGE: # ./append_idmef.pl <rules_file>\n";
}

open(RULES,"< $rules_file") or die "ERROR: can not open $rules_file: $!\n";

LOOP: while(<RULES>) {
   $line = $_;
   if($line =~ /^\#/) {    # don't alter rules that are commented out
       print $line;
       next LOOP;
   }

   # We're calling any line with a ->, <-, or <> in it a rule.  Skip if it
   # does not have one of them.
   unless($line =~ /\-\>|\<\-|\<\>/) {
       print $line;
       next LOOP;
   }

   if($line =~ /WEB|ColdFusion|FrontPage|IIS/i)  # Any web-type stuff?
   {   $line =~ s/\)\s*$/ idmef: web;\)\n/; }
   else
   {   $line =~ s/\)\s*$/ idmef: default;\)\n/; }
   print $line;
}

close(RULES);
