<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 * Input GET/POST variables
 *   - submit:
 *   - time:
 *   - time_sep:
 */

  include ("acid_conf.php");
  include ("acid_db.inc");
  include ("acid_net.inc");
  include ("acid_db_common.php");
  include ("acid_common.php");
  include ("acid_graph_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <META HTTP-EQUIV="pragma" CONTENT="no-cache">
    <TITLE>ACID: Graph Alert Data</TITLE>
  <LINK rel="stylesheet" type="text/css" href="acid_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Graph Alert data</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>

</TR>
</TABLE>
<P><P>

<?php
  LoadGraphingLib($ChartLib_path);
?>

<FORM ACTION="acid_graph_main.php" METHOD="post">

<TABLE WIDTH="100%" BORDER=2 BGCOLOR="#CCCC99">
  <TR>
     <TD COLSPAN=2>
<?php
  set_time_limit($max_script_runtime);

  /* Set default chart values */
  if ( $submit == "" )
  {
     $height = 400;
     $width = 400;
     $user_chart_title = "ACID Chart";
     $min_size = 0;
     $rotate_xaxis_lbl = 0;
     $xaxis_label_inc = 1;
     $chart_style = "bar";
     $use_alerts = 0;
  }

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  echo '<B>Chart Title:</B> &nbsp;
            <INPUT TYPE="text" NAME="user_chart_title" SIZE=60 VALUE="'.$user_chart_title.'"><BR>'; 
        
  echo '<B>Chart Type:</B>&nbsp;
        <SELECT NAME="chart_type">
         <OPTION VALUE=" "  '.chk_select($chart_type, " ").'>{ chart type }
         <OPTION VALUE="1" '.chk_select($chart_type, "1").'>Time (hour) vs. Number of Alerts
         <OPTION VALUE="2" '.chk_select($chart_type, "2").'>Time (day) vs. Number of Alerts
         <!--<OPTION VALUE="3" '.chk_select($chart_type, "3").'>Time (week) vs. Number of Alerts-->
         <OPTION VALUE="4" '.chk_select($chart_type, "4").'>Time (month) vs. Number of Alerts
         <!--<OPTION VALUE="5" '.chk_select($chart_type, "5").'>Time (year) vs. Number of Alerts-->
         <OPTION VALUE="6" '.chk_select($chart_type, "6").'>Src. IP address vs. Number of Alerts
         <OPTION VALUE="7" '.chk_select($chart_type, "7").'>Dst. IP address vs. Number of Alerts
         <OPTION VALUE="8" '.chk_select($chart_type, "8").'>Dst. UDP Port vs. Number of Alerts
         <OPTION VALUE="10" '.chk_select($chart_type, "10").'>Src. UDP Port vs. Number of Alerts
         <OPTION VALUE="9" '.chk_select($chart_type, "9").'>Dst. TCP Port vs. Number of Alerts
         <OPTION VALUE="11" '.chk_select($chart_type, "11").'>Src. TCP Port vs. Number of Alerts
        </SELECT>';

  // Do you need other periods? Simply add them!
  echo '&nbsp;&nbsp;<b>Chart Period:</B>&nbsp;
        <SELECT NAME="chart_interval">
         <OPTION VALUE="0"  '.chk_select($chart_interval, "0").'>no period
         <OPTION VALUE="7" '.chk_select($chart_interval, "7").'>7 (a week)
         <OPTION VALUE="24" '.chk_select($chart_interval, "24").'>24 (whole day)
         <OPTION VALUE="168" '.chk_select($chart_interval, "168").'>168 (24x7)
        </SELECT><BR>';

  echo '&nbsp;&nbsp;<B>Size: (width x height)</B>
        &nbsp;<INPUT TYPE="text" NAME="width" SIZE=4 VALUE="'.$width.'">
        &nbsp;<B>x</B>
        &nbsp;<INPUT TYPE="text" NAME="height" SIZE=4 VALUE="'.$height.'">
        &nbsp;&nbsp;';
  echo '<B>Graph type:</B> &nbsp;&nbsp;
            <INPUT TYPE="radio" NAME="chart_style" 
                   VALUE="bar" '.chk_check($chart_style, "bar").'> bar &nbsp;&nbsp
            <INPUT TYPE="radio" NAME="chart_style" 
                   VALUE="line" '.chk_check($chart_style, "line").'> line';

  echo '<br><b>Chart Begin:</B>&nbsp;
        <SELECT NAME="chart_begin_hour">
         <OPTION VALUE=" "  '.chk_select($chart_begin_hour, " ").'>{hour}';
        for ( $i = 0; $i <= 23; $i++ )
            printf("<OPTION VALUE=\"%02d\" '.chk_select($chart_begin_hour, \"%02d\").'>%02d",
                   $i, $i, $i);
  echo '</SELECT>
        <SELECT NAME="chart_begin_day">
         <OPTION VALUE=" "  '.chk_select($chart_begin_day, " ").'>{day}';
        for ( $i = 1; $i <= 31; $i++ )
            printf("<OPTION VALUE=\"%02d\" '.chk_select($chart_begin_day, \"%02d\").'>%02d",
                   $i, $i, $i);
  echo '</SELECT>
        <SELECT NAME="chart_begin_month">
         <OPTION VALUE=" "  '.chk_select($chart_begin_month, " ").'>{month}
         <OPTION VALUE="01" '.chk_select($chart_begin_month, "01").'>January
         <OPTION VALUE="02" '.chk_select($chart_begin_month, "02").'>February
         <OPTION VALUE="03" '.chk_select($chart_begin_month, "03").'>March
         <OPTION VALUE="04" '.chk_select($chart_begin_month, "04").'>April
         <OPTION VALUE="05" '.chk_select($chart_begin_month, "05").'>May
         <OPTION VALUE="06" '.chk_select($chart_begin_month, "06").'>June
         <OPTION VALUE="07" '.chk_select($chart_begin_month, "07").'>July
         <OPTION VALUE="08" '.chk_select($chart_begin_month, "08").'>August
         <OPTION VALUE="09" '.chk_select($chart_begin_month, "09").'>September
         <OPTION VALUE="10" '.chk_select($chart_begin_month, "10").'>October
         <OPTION VALUE="11" '.chk_select($chart_begin_month, "11").'>November
         <OPTION VALUE="12" '.chk_select($chart_begin_month, "12").'>December
        </SELECT>
        <SELECT NAME="chart_begin_year">
        <OPTION VALUE=" " '.chk_select($chart_begin_year, " ").'>{year}
        <OPTION VALUE="1999" '.chk_select($chart_begin_year, "1999").'>1999
        <OPTION VALUE="2000" '.chk_select($chart_begin_year, "2000").'>2000
        <OPTION VALUE="2001" '.chk_select($chart_begin_year, "2001").'>2001
        <OPTION VALUE="2002" '.chk_select($chart_begin_year, "2002").'>2002
        </SELECT>';


  echo '<br><b>Chart End:</B>&nbsp;&nbsp;&nbsp;&nbsp;
        <SELECT NAME="chart_end_hour">
         <OPTION VALUE=" "  '.chk_select($chart_end_hour, " ").'>{hour}';
        for ( $i = 0; $i <= 23; $i++ )
            printf("<OPTION VALUE=\"%02d\" '.chk_select($chart_begin_hour, \"%02d\").'>%02d",
                   $i, $i, $i);
  echo '</SELECT>
        <SELECT NAME="chart_begin_day">
         <OPTION VALUE=" "  '.chk_select($chart_end_day, " ").'>{day}';
        for ( $i = 1; $i <= 31; $i++ )
            printf("<OPTION VALUE=\"%02d\" '.chk_select($chart_end_day, \"%02d\").'>%02d",
                   $i, $i, $i);
  echo '</SELECT>
        <SELECT NAME="chart_end_month">
         <OPTION VALUE=" "  '.chk_select($chart_end_month, " ").'>{month}
         <OPTION VALUE="01" '.chk_select($chart_end_month, "01").'>January
         <OPTION VALUE="02" '.chk_select($chart_end_month, "02").'>February
         <OPTION VALUE="03" '.chk_select($chart_end_month, "03").'>March
         <OPTION VALUE="04" '.chk_select($chart_end_month, "04").'>April
         <OPTION VALUE="05" '.chk_select($chart_end_month, "05").'>May
         <OPTION VALUE="06" '.chk_select($chart_end_month, "06").'>June
         <OPTION VALUE="07" '.chk_select($chart_end_month, "07").'>July
         <OPTION VALUE="08" '.chk_select($chart_end_month, "08").'>August
         <OPTION VALUE="09" '.chk_select($chart_end_month, "09").'>September
         <OPTION VALUE="10" '.chk_select($chart_end_month, "10").'>October
         <OPTION VALUE="11" '.chk_select($chart_end_month, "11").'>November
         <OPTION VALUE="12" '.chk_select($chart_end_month, "12").'>December
        </SELECT>
        <SELECT NAME="chart_end_year">
        <OPTION VALUE=" " '.chk_select($chart_end_year, " ").'>{year}
        <OPTION VALUE="1999" '.chk_select($chart_end_year, "1999").'>1999
        <OPTION VALUE="2000" '.chk_select($chart_end_year, "2000").'>2000
        <OPTION VALUE="2001" '.chk_select($chart_end_year, "2001").'>2001
        <OPTION VALUE="2002" '.chk_select($chart_end_year, "2002").'>2002
        </SELECT>';

  echo '<INPUT TYPE="submit" NAME="submit" VALUE="Graph Alerts"><BR>
        &nbsp;&nbsp; <BR>
        </TD></TR>';

  echo '<TR><TD>
        <TABLE WIDTH="100%" BORDER=1>
        <TR>
         <TD ALIGN="CENTER" WIDTH="70%"><B>X Axis</B></TD>
         <TD ALIGN="CENTER" WIDTH="30%"><B>Y Axis</B></TD>
        </TR>
        <TR>
         <TD>
           <B>Data Source:</B> &nbsp;
           <SELECT NAME="data_source">
           <OPTION VALUE=" " '.chk_select($data_source, " ").'>{ data source (AG) }';
           
           $temp_sql = "SELECT ag_id, ag_name FROM acid_ag";
           $tmp_result = $db->acidExecute($temp_sql);
           if ( ( $tmp_result ) )
           {
              while ( $myrow = $tmp_result->acidFetchRow() )
                echo '<OPTION VALUE="'.$myrow[0].'" '.chk_select($data_source, $myrow[0]).'>'.
                     '['.$myrow[0].'] '.$myrow[1];

              $tmp_result->acidFreeRows();
           }
 
           echo '</SELECT><BR>
                 <!--<B>Use Alerts of Type:</B>
                   <SELECT NAME="use_alerts">
                     <OPTION VALUE="0" '.chk_select($use_alerts, 0).'>alerts+portscans 
                     <OPTION VALUE="1" '.chk_select($use_alerts, 1).'>alerts only
                     <OPTION VALUE="2" '.chk_select($use_alerts, 2).'>portscans only
                     <OPTION VALUE="3" '.chk_select($use_alerts, 3).'>alert and portscans seperately
                   </SELECT><BR>-->
                 <B>Minimum Threshold Value ( &gt;= ):</B> 
                 <INPUT TYPE="text" NAME="min_size" SIZE=5 VALUE='.$min_size.'>
                 &nbsp;&nbsp;
                 <INPUT TYPE="checkbox" NAME="rotate_xaxis_lbl" VALUE="1" '.
                   chk_check($rotate_xaxis_lbl, "1").'>
                 &nbsp;
                 <B>Rotate Axis Labels (90 degrees)</B><BR>
                 <B>Display X-axis label every
                 <INPUT TYPE="text" NAME="xaxis_label_inc" SIZE=4 VALUE='.$xaxis_label_inc.'>
                 &nbsp; data points
         </TD>
         <TD>
           <INPUT TYPE="checkbox" NAME="yaxis_scale" VALUE="1">&nbsp;Y-axis logarithmic
         </TD>
        </TR>
        </TABLE></TD></TR>';
  echo '</TABLE>';

  echo '</FORM>

        <P><HR>';

  $data_pnt_cnt = 0;
  /* Error Conditions */
  if ( $submit != "" && $data_source == " " )
     echo '<FONT><B>No AG was selected for the data source</B>.</FONT>';     
  else if ( $submit != "" && $chart_type == " " )
     echo '<FONT><B>No chart type was specified</B>.</FONT>';
  else if ( $data_source == " " )
     echo '<FONT><B>No AG was specified</B>.</FONT>';

  /* Calculate the data set */
  else if ($submit != "")
  {
     unset($xdata);
     unset($xlabel);

     if ( $debug_mode > 1 )  echo "<H3>Starting data import ...</H3>";

     switch ($chart_type)
     {
         case 1:
         case 2:
         case 3:
         case 4:
         case 5:
         {
            $chart_title = "Time vs. Number of Alerts";
            $xaxis_label = "Time";
            $yaxis_label = "Alert Occurances";
            $data_pnt_cnt = GetTimeDataSet($xdata, $chart_type, $data_source, $min_size);
            $chart_title = $chart_title."\n ( ".$xdata[0][0]." - ".$xdata[count($xdata)-1][0]." )";
            break;
         }
         case 6:  // Src. IP vs. Num Alerts
         {
            $chart_title = "Source IP vs. Number of Alerts";
            $xaxis_label = "Source IP Address";
            $yaxis_label = "Alert Occurances";

            $data_pnt_cnt = GetIPDataSet($xdata, $chart_type, $data_source, $min_size);
            break;
         }
         case 7:  // Dst. IP vs. Num Alerts
         {
            $chart_title = "Destination IP vs. Number of Alerts";
            $xaxis_label = "Destination IP Address";
            $yaxis_label = "Alert Occurances";

            $data_pnt_cnt = GetIPDataSet($xdata, $chart_type, $data_source, $min_size);
            break;
         }
         case 8:  // UDP Port vs. Num Alerts 
         {
            $chart_title = "UDP Port (Destination) vs. Number of Alerts";
            $xaxis_label = "Dst. UDP Port";
            $yaxis_label = "Alert Occurances";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size);
            break;
         }
         case 10:  // UDP Port vs. Num Alerts 
         {
            $chart_title = "UDP Port (Source) vs. Number of Alerts";
            $xaxis_label = "Src. UDP Port";
            $yaxis_label = "Alert Occurances";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size);
            break;
         }
         case 9:  // TCP Port vs. Num Alerts 
         {
            $chart_title = "TCP Port (Destination) vs. Number of Alerts";
            $xaxis_label = "Dst. TCP Port";
            $yaxis_label = "Alert Occurances";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size);
            break;
         }
         case 11:  // TCP Port vs. Num Alerts 
         {
            $chart_title = "TCP Port (Source) vs. Number of Alerts";
            $xaxis_label = "Src. TCP Port";
            $yaxis_label = "Alert Occurances";

            $data_pnt_cnt = GetPortDataSet($xdata, $chart_type, $data_source, $min_size);
            break;
         }
     }

     if ( $data_pnt_cnt > 0 )
     {

        if ( $debug_mode > 0 )
           echo "<H3>Handling Period if necessary ...</H3>\n";
        if ( $chart_interval ) {
          // set up array
          for ( $i = 0; $i < $chart_interval; $i++ ) {
            $chart_array [$i][0] = $i;
            $chart_array [$i][1] = 0;
          }
          // loading data
          for ( $i = 0; $i < count ($xdata); $i++ ) {
            $chart_array [ $i % $chart_interval ][1] += $xdata [$i][1];
          }
          // set up xdata
          $xdata = $chart_array;
        }

        if ( $debug_mode > 0 )   
           echo "<H3>Dumping data ... (writting only every $xaxis_label_inc)</H3>";
        $data_str = "";
        $data_lbl_str = "";
        for ( $i = 0; $i < count($xdata); $i++)
        {
          if ( $debug_mode > 0 )
             echo $i." -- ".$xdata[$i][0]." - ".$xdata[$i][1]."<BR>";
        
          /* Apply the X-Axis label clean-up -- 
           * only write every N axis labels (erase the rest) 
           */
          if ( ($i % $xaxis_label_inc ) == 0 )
             $data_lbl_str = $data_lbl_str."&datalbl".rawurlencode("[$i]")."=".
                                    rawurlencode($xdata[$i][0]);
          else
             $data_lbl_str = $data_lbl_str."&datalbl".rawurlencode("[$i]")."=";

          $data_str = $data_str."&data".rawurlencode("[$i]")."=".
                            rawurlencode($xdata[$i][1]);
        }

        if ( $debug_mode > 0 )  echo "<H3>Drawing graph ($width x $height)</H3>";

        echo '<CENTER>
              <TABLE BGCOLOR="#000000" CELLSPACING=0 CELLPADDING=2 BORDER=0>
              <TR>
              <TD>';

        echo "<CENTER>
              <IMG SRC=\"acid_graph_display.php?width=$width&height=$height".
                      "&title=".rawurlencode($user_chart_title."\n".$chart_title).
                      "&xaxis_label=".rawurlencode($xaxis_label).
                      "&yaxis_label=".rawurlencode($yaxis_label).
                      "&yaxis_scale=".rawurlencode($yaxis_scale).
                      "&rotate_xaxis_lbl=".rawurlencode($rotate_xaxis_lbl).
                      "&style=".$chart_style.
                      $data_str.$data_lbl_str."\"></CENTER>";

        echo '</TD>
              </TR>
              </TABLE>
              </CENTER>';
      }
      else
        echo "<H3>No data points to plot</H3>";
   }

?>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

