<?php

$ACID_VERSION = "0.9.6b11";

/* Path to the DB abstraction library */
$DBlib_path = "";

/* The type of underlying alert database
  
   MySQL       : "mysql"
   PostgresSQL : "postgres"
 */
$DBtype = "mysql";

/* Alert DB connection parameters
    - $alert_dbname   : MySQL database name of Snort alert DB
    - $alert_host     : host on which the DB is stored
    - $alert_port     : port on which to access the DB
    - $alert_user     : login to the database with this user
    - $alert_password : password of the DB user

   This information can be gleaned from the Snort database
   output plugin configuration.
 */
$alert_dbname   = "snort_log";
$alert_host     = "localhost";
$alert_port     = "";
$alert_user     = "root";
$alert_password = "mypassword";

/* Archive DB connection parameters */
$archive_dbname   = "snort_archive";
$archive_host     = "localhost";
$archive_port     = "";
$archive_user     = "root";
$archive_password = "mypassword";

/* Path to the graphing library */
$ChartLib_path = "";

/* File format of charts ('png', 'jpeg', 'gif') */
$chart_file_format = "png";

/* Chart default colors - (red, green, blue)
     - $chart_bg_color_default    : background color of chart
     - $chart_lgrid_color_default : gridline color of chart
     - $chart_bar_color_default   : bar/line color of chart
 */
$chart_bg_color_default     = array(255,255,255);
$chart_lgrid_color_default  = array(205,205,205);
$chart_bar_color_default    = array(190, 5, 5);

/* Maximum number of rows per criteria element */
$MAX_ROWS = 10;

/* Number of rows to display for any query results */
$show_rows = 50;

/* Number of alerts to return during a snapshot  
   Last _X_ # of alerts */
$last_num_alerts = 15;

/* Number of unique alerts to return during a snapshot */
$last_num_ualerts = 15;

/* Number of Unique alerts to return during a snapshot */
$freq_num_alerts = 5;

/* Number of unique ip addresses to return during a snapshot */
$freq_num_uaddr = 15;

/* Number of scroll buttons to use when displaying query results */
$max_scroll_buttons = 12; 

/* Debug mode - How much debugging information should be shown
    0 : no extra information
    1 : extended debugging information 
 */
$debug_mode = 0;

/* Should certain statistics pages refresh? */
$refresh_stat_page = 1;

/* Number of seconds between refreshes of a statistics page */
$stat_page_refresh_time = 180;

/* Display First/Previous/Last timestamps for alerts or
   just First/Last on the Unique Alert listing.
     1: yes
     0: no
*/
$show_previous_alert = 0;

/* Sets maximum execution time (in seconds) of any particular page. 
   Note: this overrides the PHP configuration file variable 
         max_execution_time.  Thus script can run for a total of
         ($max_script_runtime + max_execution_time) seconds */
$max_script_runtime = 180;

/* How should the IP address criteria be entered in the Search screen?
    1 : each octet is a separate field
    2 : entire address is as a single field
 */
$ip_address_input = 2;

/* Resolve IP to FQDN (on certain queries?) 
     1 : yes
     0 : no 
 */
$resolve_IP = 1;

/* DNS cache lifetime (in minutes) */
$dns_cache_lifetime = 20160;

/* Whois information cache lifetime (in minutes) */
$whois_cache_lifetime = 40320;

/* Snort spp_portscan log file */
$portscan_file = "";

?>
