<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

function AddSelectedToAG($ag_add, $num_rows, $ag_add_type, $ag_add_key, $ag_method, $sql, $db)
{
  $ag_id = "";
  $added_alert_num = 0;
  $dup_cnt = 0;

  /* if the AG key is a name qualify it to an id */
  if ( $ag_add_type == "ag_by_name" )
     $ag_id = GetAGIDbyName($ag_add_key, $db);
  else if ( $ag_add_type == "ag_by_id" )
  {
     $ag_id = $ag_add_key;

     if ( VerifyAGID($ag_id, $db ) == 0 )
     {
        ErrorMessage("Uknown AG ID specified");
        $ag_id = "";
     }
  }
  else
     ErrorMessage("Unrecognized AG key type");

  if ( $ag_id != "" )
  {
     if ( $ag_method == "Entire Query" )
     {
        $result = mysql_query($sql, $db);
        if ( mysql_errno($db) > 0 )
        {
           ErrorMessage("Error retrieving alert list to add the entire query to an AG");
           return -1;
        }
     }
     for ( $i = 0; $i < $num_rows; $i++ )
     {
         if ( $ag_add[$i] != "" || $ag_method == "Entire Query")
         {
            if ( $ag_method == "Entire Query" )
            {
               $myrow = mysql_fetch_row($result);
               $sid = $myrow[0];
               $cid = $myrow[1];  
            }
            else 
               GetQueryResultID($ag_add[$i], $seq, $sid, $cid);

            $sql2 = "INSERT INTO acid_ag_alert (ag_id, ag_sid, ag_cid) ".
                   "VALUES ('".$ag_id."','".$sid."','".$cid."');";
            mysql_query($sql2, $db);

            $error = mysql_errno($db);
            if ( $error > 0 && $error != 1062)
               ErrorMessage("Error Inserting Alerts into AG");
            else if ( $error == 1062 )
               ++$dup_cnt; 
            else
               ++$added_alert_num; 
        }
     }

     if ( $method == "Entire Query" )
        mysql_free_result($result);

     if ( $added_alert_num > 0 )
        ErrorMessage("Successfully added ".$added_alert_num." alert(s) to AG #".$ag_id);
     if ( $dup_cnt > 0 )
        ErrorMessage("Ignored ".$dup_cnt." duplicate alert(s) attempted to be added to AG #".$ag_id);
     if ( $added_alert_num == 0 && $dup_cnt == 0 )
        ErrorMessage("No alerts were selected");
  }
}

function GetAGIDbyName($ag_name, $db)
{
  $ag_id = "";
  $sql = "SELECT ag_id FROM acid_ag WHERE ag_name='".$ag_name."'";

  $result = mysql_query($sql, $db);

  if ( mysql_errno($db) > 0 )
     ErrorMessage("The specified AG name search is invalid.  Try again!");
  else if ( mysql_num_rows($result) < 1 )
     ErrorMessage("The specified AG does not exist.");
  else
  {
        $myrow = mysql_fetch_row($result);
        $ag_id = $myrow[0]; 
        mysql_free_result($result);
  }

  return $ag_id;
}

function GetAGNamebyID($ag_id, $db)
{
  $ag_name = "";
  $sql = "SELECT ag_name FROM acid_ag WHERE ag_id='".$ag_id."'";

  $result = mysql_query($sql, $db);

  if ( mysql_errno($db) > 0 )
     ErrorMessage("The specified AG ID search is invalid.  Try again!");
  else if ( mysql_num_rows($result) < 1 )
     ErrorMessage("The specified AG does not exist.");
  else
  {
        $myrow = mysql_fetch_row($result);
        $ag_name = $myrow[0]; 
        mysql_free_result($result);
  }

  return $ag_name;
}

function VerifyAGID($ag_id, $db)
{
  $sql = "SELECT ag_id FROM acid_ag WHERE ag_id='".$ag_id."'";
  $result = mysql_query($sql, $db);

  if ( mysql_errno($db) > 0 )
  {
     ErrorMessage("Error looking up an AG ID");
     return 0;
  }
  else if ( mysql_num_rows($result) < 1 )
     return 0;
  else
     return 1;
}

?>


