#!/usr/bin/perl

# ann_xml.pl, distributed as part of Snortsnarf v062000.1
# Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
# copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
# Released under GNU General Public License, see the COPYING file included
# with the distribution or http://www.silicondefense.com/snortsnarf/ for
# details.

# ann_xml.pl contains useful functions in working with the annotation base XML.

# Please send complaints, kudos, and especially improvements and bugfixes to
# hoagland@SiliconDefense.com.  As described in GNU General Public License, no
# warranty is expressed for this program. 

require "xml_help.pl";

sub annsroot_for_key {
	my($tree,$search_type,$search_key)= @_;
	my @content= @{$tree->[1]};
	shift @content;
	while (@content) {
 	   $tagname=shift(@content);
 	   $content=shift(@content);
 	   next unless $tagname eq 'ANNOTATIONS';
 	   # content is like [{...}, 'type',[...], 'key',[...], 'annotation',[...], 'annotation',[...],...]
 	   ($type,$key)= &get_type_and_key($content);
 	   return $content if $type eq $search_type && $key eq $search_key;
	}
	return undef;
}

sub get_type_and_key {
    my($anns)= shift;
    my @content= @{$anns};
    shift @content;
    my($tagname,$content,$type,$key,$info);
    $type= $key= undef;
    @annlist=();
    while (@content) {
        $tagname=shift(@content);
        $info= shift(@content);
        #print "tagname=$tagname; $info=(",join(',',@{$info}),")\n";
        if ($tagname eq 'TYPE') {
            $type= $info->[2];
        } elsif ($tagname eq 'KEY') {
            $key= $info->[2];
        } else {
            next;
        }
    }      
    return ($type,$key);
}

sub add_new_anns_entry {
	my($root,$type,$key,$author,$subject,$note)= @_;
	my $root_content= $root->[1];
	my $annsroot= [{}, 'TYPE',[{},0,$type], 'KEY',[{},0,$key]];
	push(@{$root_content},'ANNOTATIONS',$annsroot); 
	&append_to_annsroot($annsroot,$author,$subject,$note);
}

sub append_to_annsroot {
	my($annsroot,$author,$subject,$note)= @_;
	my(@t)=localtime(time());
	my $date=($t[5]+1900)."/".($t[4]+1)."/$t[3]";
	push(@{$annsroot},'ANNOTATION',[{}, 'AUTHOR',[{},0,$author], 'DATE',[{},0,$date], 'SUBJECT',[{},0,$subject], 'NOTE',[{},0,$note]]);
}

1;

# $Id: ann_xml.pl,v 1.6 2000/06/21 00:30:56 jim Exp $
