#!/usr/bin/perl

# view_annotations.pl, distributed as part of Snortsnarf v062000.1
# Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
# copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
# Released under GNU General Public License, see the COPYING file included
# with the distribution or http://www.silicondefense.com/snortsnarf/ for
# details.

# view_annotations.pl is a CGI script to retrieve the annotations for a 
# certain type and key from the annotation base given and to present a form
# to add new entries.

# Please send complaints, kudos, and especially improvements and bugfixes to
# hoagland@SiliconDefense.com.  As described in GNU General Public License, no
# warranty is expressed for this program.

use CGI;
use XML::Parser;

# get paramaters of the invocation
$input= new CGI;
foreach (@ARGV) {  # simulate field input if running on command line
  $input->param(split('=',$_,2));
}
$source_file= $input->param('file');
$search_type= $input->param('type');
$search_key= $input->param('key');


# print out headers
print $input->header(-header => 'text/html',-expires => '+0d');


# create a tree representing the XML in the given file
-e $source_file || die "annotation file $source_file does not exist";
$xml= new XML::Parser(Style => 'Tree');
$tree= $xml->parsefile($source_file);

$tree->[0] eq "ANNOTATION-BASE" || die "invalid XML file ($source_file); expected root element to be ANNOTATION-BASE";
@content= @{$tree->[1]};
shift @content;
while (@content) {
    $tagname=shift(@content);
    $content=shift(@content);
    next unless $tagname eq 'ANNOTATIONS';
    ($type,$key,@annlist)= &get_anns_info($content);
    last if $type eq $search_type && $key eq $search_key;
    @annlist=(); # in case this is the last iteration of the loop
}
# @annlist now contains a list of the annotation subtrees found

print <<">>";
<HTML>
<HEAD>
<TITLE>Annotations for $search_type "$search_key"</TITLE>
</HEAD>
<BODY bgcolor="#E7DEBD">
<H1>Annotations for $search_type "$search_key"</H1>
>>

if (@annlist==0) {
    print "No annotations were found for entry type \"$search_type\" with key \"$search_key\".\n";
} else {
    print '<TABLE border CELLPADDING=5><TR ALIGN=center><TD><B>Subject</B></TD><TD><B>Author</B></TD><TD><B>Date</B></TD><TD><B>Annotation</B></TD></TR>';
    foreach $anntree (@annlist) {
        ($author,$date,$subject,$note)=&get_ann_info($anntree);
        $note =~ s/[\n\r]/\<BR\>/g;
        print "\n<TR ALIGN=center><TD>$subject</TD><TD>$author</TD><TD>$date</TD><TD>$note</TD></TR>";
    }
    print "</TABLE>\n";
}
print <<">>";
<HR>
Add an annotation:
<FORM ACTION="add_annotation.pl" METHOD="post">
<INPUT TYPE="hidden" NAME="file" VALUE="$source_file">
<INPUT TYPE="hidden" NAME="type" VALUE="$search_type">
<INPUT TYPE="hidden" NAME="key" VALUE="$search_key">

<TABLE>
	<TR><TD align=right>Your name:</TD><TD align=left><INPUT TYPE="text" NAME="author" SIZE="12"></TD></TR>
	<TR><TD align=right>Subject:</TD><TD align=left><INPUT TYPE="text" NAME="subject" SIZE="20"></TD></TR>
	<TR><TD align=right>Note:</TD><TD align=left><TEXTAREA NAME="note" ROWS="6" COLS="60"></TEXTAREA></TD></TR>
</TABLE>
<INPUT TYPE="submit" VALUE="Add Annotation">
<HR>
</FORM>
<P>
Use your browser's back command to return to the previous page.
<P>
Generated by $0 from $source_file
</BODY>
</HTML>
>>

sub get_anns_info {
    my($anns)= shift;
    my @content= @{$anns};
    shift @content;
    my($tagname,$content,$type,$key,@annlist);
    $type= $key= undef;
    @annlist=();
    while (@content) {
        $tagname=shift(@content);
        my @info= @{shift(@content)};
        if ($tagname eq 'TYPE') {
            $type= $info[2];
        } elsif ($tagname eq 'KEY') {
            $key= $info[2];
        } elsif ($tagname eq 'ANNOTATION') {
        	shift(@info);
            push(@annlist,\@info);
        } else {
            next;
        }
    }      
    return ($type,$key,@annlist);
}

sub get_ann_info {
    my($ann)= shift;
    my @content= @{$ann};
    #shift @content;
    my($tagname,$content,$author,$date,$subject,$note);
    $author= $date= $subject= $note= '';
    while (@content) {
        $tagname=shift(@content);
        my $content= shift(@content);
        $content= $content->[2];
        if ($tagname eq 'AUTHOR') {
            $author= $content;
        } elsif ($tagname eq 'DATE') {
            $date= $content;
        } elsif ($tagname eq 'SUBJECT') {
            $subject= $content;
        } elsif ($tagname eq 'NOTE') {
            $note= $content;
        } else {
            next;
        }
    }      
    return ($author,$date,$subject,$note);
}

1;

# $Id: view_annotations.pl,v 1.7 2000/06/21 00:30:56 jim Exp $
