#include "sncon.h"


extern cltnode *clthead;
extern cltnode *cltnext;

struct sockaddr_in clt_addr;
unsigned long clt_id;
int maxfd;
fd_set allset;

//extern FILE *iaplog;
#ifdef EXTRA_DEBUG
FILE *mylog;
#endif

int main(int argc,char **argv) {

int sd;
int done;

	done = 0;
	printf(SNBANNER);


	
	if ((sd = bind_socket(1033))<0) {
		perror("bind");
		exit(1);
	}
	/* initialize ncurses screen */

	sn_initscr();
	sig_init();
	connects_init();

	//iaplog = fopen("./iaplog","a");

#ifdef EXTRA_DEBUG
	mylog=fopen("./log","a");
#endif
	
#ifdef TCPWRAPPERS
	allow_severity = LOG_INFO;
	deny_severity  = LOG_NOTICE;
#endif


	maxfd=sd + 1;
	FD_ZERO(&allset);
	FD_SET(sd, &allset);

	while(!done) 
		poll_select(sd);
	

#ifdef HAVE_NCURSES
	sn_endscr();
#endif
	return 0;
}

int accept_connection(int sd) {
int sd2;
int fromlen;
int pid = -1;

#ifdef EXTRA_DEBUG
	fprintf(mylog,"accepting connection\n");
#endif	
	fromlen=sizeof(struct sockaddr_in);
	sd2 = accept(sd,(struct sockaddr *)&clt_addr, &fromlen);

	if (sd2<0) return -1;
		
#ifdef TCPWRAPPERS
	if (!hosts_ctl("snortnet",STRING_UNKNOWN,
		inet_ntoa(clt_addr.sin_addr), STRING_UNKNOWN)) {
		refuse_node_connect(&clt_addr);
		close(sd2);
		return -1;
	}
#endif

#ifdef DEBUG
		printf("[%s] Connected. pid %i\n",
			inet_ntoa(clt_addr.sin_addr), pid);
#endif
		add_node_connect(&clt_addr,pid);
	

			

	if((pid=fork())) { /* parent */
		/* lame hack to put PID there */
		cltnext->prev->pid = pid;
		close(sd2);
	} else { /* child */
		int ret;
		close(sd);
		ret = serve(sd2, &clt_addr, cltnext->prev);
		close(sd2);
		exit(ret);
	} /* if-else */

	return 0;
}

int bind_socket(int port) {
	int sd;
	struct sockaddr_in srv,clt;
	const int on = 1;
	if((sd=socket(AF_INET,SOCK_STREAM,0))<0) {
		perror("socket");
		return -1;
	}
	if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR,
		(char *)&on, sizeof(on)) != 0) {
		perror("setsockopt(SO_REUSEADDR)");
		close(sd);
		return -1;
	}
	bzero(&srv,sizeof(srv));
	bzero(&clt,sizeof(clt));
	srv.sin_addr.s_addr=INADDR_ANY;
	srv.sin_port=htons(port);
	srv.sin_family=AF_INET;
	if(bind(sd,(struct sockaddr *)&srv,sizeof(struct sockaddr_in))<0) {
		perror("bind");
		close(sd);
		return -1;
	}
	if(listen(sd,1)<0) {
		perror("listen");
		close(sd);
		return -1;
	}
return sd;
}
int serve(int sd, struct sockaddr_in *cltaddr, cltnode *me) {
int pid;
NetAlert *alert;
iap_rec r;

pid=getpid();

bzero(&r, sizeof(r));


/*
 * 3 stages of initial greeting.. 
 */

if (iap_get_request(sd, &r)>0)
	iap_response(sd, 200, NULL);
else
	return 1;

if (iap_get_request(sd, &r)>0)
	iap_response(sd, 200, NULL);
else
	return 2;
if (iap_get_request(sd, &r)>0)
	iap_response(sd, 200, NULL);
else
	return 3;


	for (;;) {

		if (iap_get_request(sd, &r)>-1) {
			if (r.content_type == NULL || 
					r.content_length == 0 ||
					r.content == NULL) {
				return 4; // mess with protocol
			}
			
			alert = (NetAlert *)r.content;
			
		write_alert(alert, cltaddr, me);
		iap_response(sd, 200, NULL);
		free(r.content);
		free(r.content_type);
		r.content_length = 0;
		r.content = NULL;
		r.content_type = NULL;
		} else {
			return 5; // lost conenction
		}
 
	} /* for */
} /* eof */
