%{
/*	$Id: scan.l,v 1.15 2006/02/08 13:38:59 mbalmer Exp $ */

/*
 * Copyright (c) 2005, 2006 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <string.h>

#if !defined(__FreeBSD__)
#include "y.tab.h"
#else
#include "parse.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

backend			{ return BACKEND; }
virus-strategy		{ return VIRUS_STRATEGY; }
error-strategy		{ return ERROR_STRATEGY; }
spam-strategy		{ return SPAM_STRATEGY; }
unwanted-strategy	{ return UNWANTED_STRATEGY; }
port			{ return PORT; }
tmpdir			{ return TMPDIR; }
log-facility		{ return LOGFAC; }
recipient-notification	{ return RECIPIENT_NOTIFICATION; }
notify-only		{ return NOTIFY_ONLY; }
pidfile			{ return PIDFILE; }
option			{ return OPTION; }
user			{ return USER; }
group			{ return GROUP; }
chroot			{ return CHROOT; }
tmpfiles		{ return TMPFILES; }
maxfiles		{ return MAXFILES; }
maxprocs		{ return MAXPROCS; }
spam-subject-prefix	{ return SPAM_SUBJECT_PREFIX; }
logfile			{ return LOGFILE; }
config-file		{ return CFGFILE; }
timeout			{ return TIMEOUT; }

ldaphost		{ return LDAPHOST; }
ldapport		{ return LDAPPORT; }
ldapurl			{ return LDAPURL; }
searchbase		{ return SEARCHBASE; }
binddn			{ return BINDDN; }
bindpasswd		{ return BINDPASSWD; }
usetls			{ return USETLS; }

local0			{ return LOCAL0; }
local1			{ return LOCAL1; }
local2			{ return LOCAL2; }
local3			{ return LOCAL3; }
local4			{ return LOCAL4; }
local5			{ return LOCAL5; }
local6			{ return LOCAL6; }
local7			{ return LOCAL7; }
daemon			{ return DAEMON;}
mail			{ return MAIL; }

discard			{ return DISCARD; }
mark			{ return MARK; }
notify-recipient	{ return NOTIFY_RECIPIENT; }
reject			{ return RJECT; }
tempfail		{ return TEMPFAIL; }
ignore			{ return IGNORE; }

markall			{ return MARKALL; }
logvirus		{ return LOGVIRUS; }
logspam			{ return LOGSPAM; }
logunwanted		{ return LOGUNWANTED; }
g\+r			{ return GRPRD; }
setgrp			{ return SETGRP; }

strategy		{ return STRATEGY; }
for			{ return FOR; }

react			{ return REACT; }
on			{ return ON; }
spam			{ return SPAM; }
virus			{ return VIRUS; }
unwanted-content	{ return UNWANTED_CONTENT; }
clean			{ return CLEAN; }
add			{ return ADD; }
to			{ return TO; }
table			{ return TABLE; }
delete			{ return DELETE; }
from			{ return FROM; }
second			{ return SECONDS; }
seconds			{ return SECONDS; }
minute			{ return MINUTES; }
minutes			{ return MINUTES; }
hour			{ return HOURS; }
hours			{ return HOURS; }
day			{ return DAYS; }
days			{ return DAYS; }

true			{ return TRUE; }
false			{ return FALSE; }

[0-9]+			{ vilterlval.string = strdup(viltertext); return NUMBER; }

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{ vilterlval.string = strdup(viltertext); return TEXT; }

\"([^"\n]*)["\n]	{
				viltertext[vilterleng - 1] = 0;
				vilterleng -= 2;
				vilterlval.string = strdup(viltertext + 1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }
