/*	$Id: socket.c,v 1.16 2005/05/31 17:13:53 marc Exp $	*/

/*
 * Copyright (c) 2003-2005 Marc Balmer <marc@msys.ch>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "smtp-vilter.h"

ssize_t
to_recv(int s, void *buf, size_t len, int flags, struct timeval *timeout)
{
	int	n;
	fd_set	rset;

	FD_ZERO(&rset);
	FD_SET(s, &rset);
	
	if ((n = select(s + 1, &rset, NULL, NULL, timeout)) > 0)
		return recv(s, buf, len, flags);

	return n;
}

ssize_t
to_send(int s, const char *buf, size_t len, int flags, struct timeval *timeout)
{
	int	n;
	int	sent;
	int	retval;
	fd_set	wset;

	n = sent = 0;	

	FD_ZERO(&wset);
	FD_SET(s, &wset);
	while (sent < len) {
		if ((n = select(s + 1, NULL, &wset, NULL, timeout)) > 0) {
			if ((retval = send(s, buf + sent, len - sent, flags)) != -1)
				sent += retval;
		} else
			return n;
	}
	return sent;
}

SOCK *
fdsock(int sock)
{
	SOCK *sp;
	
	sp = calloc(sizeof(SOCK), 1);
	
	if (sp != NULL) {
		sp->sock = sock;
		sp->pos = sp->buf;
	}
	
	return sp;
}

int
to_readc(SOCK *sock, char *c, struct timeval *to)
{
	if (sock->size <= 0) {
		again:
		if ((sock->size = to_recv(sock->sock, sock->buf, SOCK_BUFSIZE, 0, to)) < 0) {
			if (errno == EINTR)
				goto again;
			return -1;
		} else if (sock->size == 0)
			return 0;
		sock->pos = sock->buf;
	}

	--sock->size;
	*c = *sock->pos++;
	return 1;
}

ssize_t 
to_readln(char *str, int size, SOCK *sock, struct timeval *to)
{
	ssize_t	n, rc;
	char	c, *p;

	p = str;
	for (n = 1; n < size; n++) {
		if ((rc = to_readc(sock, &c, to)) == 1) {
			*p++ = c;
			if (c == '\n')
				break;
		} else if (rc == 0) {
			*p = 0;
			return (n - 1);
		} else
			return -1;
	}
	*p = 0;
	return n;
}

void
sclose(SOCK *s)
{
	close(s->sock);
	free(s);
}
