%{
/*	$Id: parse.y,v 1.9 2005/12/03 17:00:55 mbalmer Exp $	*/

#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "smtp-vilter.h"
#include "pathnames.h"

#if defined(__FreeBSD__) || defined(__linux__)
#include "strtonum.h"
#endif

#define MAXTRIES	256

extern FILE	*icapin;
extern int	 icaplineno;
extern char	*icaptext;

extern int	 icap_port;
extern char	*icap_host;
extern char	*bind_addr;
extern char	*icap_uri;
extern char	*icap_query;
extern int	 icap_tries;
extern int	 icap_timeout;

int	icaperror(const char *, ...);
int	icapparse(void);
int	icaplex(void);
%}

%union {
	long number;
	char *string;
}

%token	HOST PORT BIND URI QUERY TRIES TIMEOUT
%token	<string>	NUMBER
%token	<string>	TEXT

%%
statement	: /* empty */
		| statement '\n'
		| statement host '\n'
		| statement port '\n'
		| statement bind '\n'
		| statement uri '\n'
		| statement query '\n'
		| statement tries '\n'
		| statement timeout '\n'
		;

host		: HOST '=' TEXT				{
			free(icap_host);
			icap_host = $3;
		}
		;

port		: PORT '=' NUMBER			{
			const char *errstr;

			icap_port = strtonum($3, 1, 65535, &errstr);
			if (errstr)
				errx(1, "icap: port number is %s:%s", errstr, $3);
			free($3);
		}
		;

bind		: BIND '=' TEXT				{
			if (bind_addr != NULL)
				free(bind_addr);
			bind_addr = $3;
		}
		;

uri		: URI '=' TEXT				{
			free(icap_uri);
			icap_uri = $3;
		}
		;

query		: QUERY '=' TEXT			{
			free(icap_query);
			icap_query = $3;
		}
		;

tries		: TRIES '=' NUMBER			{
			const char *errstr;

			icap_tries = strtonum($3, 1, MAXTRIES, &errstr);
			if (errstr)
				errx(1, "icap: number of tries is %s:%s", errstr, $3);
			free($3);
		}
		;
timeout		: TIMEOUT '=' NUMBER			{
			const char *errstr;

			icap_timeout = strtonum($3, 0, 65535, &errstr);
			if (errstr)
				errx(1, "icap: timeout is %s:%s", errstr, $3);
			free($3);
		}
		;


%%

int
vilter_init(char *cfgfile)
{
	if (verbose)
		warnx("icap: vilter_init()");

	/* Default values */

	icap_port = 1344;
	bind_addr = NULL;

	icap_host = strdup("localhost");
	icap_uri = strdup("icap://localhost(");
	icap_query = strdup("action=SCAN");

	if (icap_host == NULL || icap_uri == NULL || icap_query == NULL)
		err(1, "icap: out of memory");

	icap_tries = 1;
	icap_timeout = 0;

	if (cfgfile == NULL)
		cfgfile = ICAP_CONF;

	icaplineno = 1;
	if ((icapin = fopen(cfgfile, "r")) != NULL) {
		while (!feof(icapin)) {
			icapparse();
		}
		fclose(icapin);
	} else if (verbose)
		warnx("icap: configuration file %s for icap backend not found, using default values", cfgfile);

	return 0;
}

int
icaperror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	va_start(ap, fmt);
	if (asprintf(&nfmt, "%d: %s", icaplineno, fmt) == -1)
		errx(1, "icap: error asprintf");
	va_end(ap);
	free(nfmt);
	return (0);
}

