%{
/*	$Id: scan.l,v 1.4 2005/04/23 12:25:32 marc Exp $ */

#include <string.h>
#if !defined(__FreeBSD__)
#include "y.tab.h"
#else
#include "parse.h"
#endif

%}

%option yylineno noyywrap nounput

%%

[ \t]+			/* ignore whitespace */ ;

host			{ return HOST; }
port			{ return PORT; }
bind			{ return BIND; }
tries			{ return TRIES; }
timeout			{ return TIMEOUT; }
scantype		{ return SCANTYPE; }
option			{ return OPTION; }

filesystem		{ return FILESYSTEM; }
socket			{ return SOCKET; }

chroot-scanrealpath	{ return CHROOT_SCANREALPATH; }

[0-9]+			{ clamdlval.string = strdup(clamdtext); return NUMBER; }

#.*\n			/* ignore comments */ ;

[a-zA-Z0-9_\-:\.,/\*]+	{ clamdlval.string = strdup(clamdtext); return TEXT; }
\"([^"\n]*)["\n]	{
				clamdtext[clamdleng - 1] = 0;
				clamdleng -= 2;
				clamdlval.string = strdup(clamdtext+1);
				return TEXT;
			}

=			{ return '='; }

\n			{ return '\n'; }

