%{
/*	$Id: parse.y,v 1.10 2005/12/03 17:00:55 mbalmer Exp $	*/

#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "smtp-vilter.h"
#include "vilter-clamd.h"
#include "pathnames.h"

#if defined(__FreeBSD__) || defined(__linux__)
#include "strtonum.h"
#endif

extern FILE	*clamdin;
extern int	 clamdlineno;
extern char	*clamdtext;

extern int	 clamd_port;
extern int	 write_from;
extern char	*clamd_host;
extern char	*bind_addr;
extern int	 clamd_tries;
extern int	 clamd_timeout;
extern int	 scantype;
extern int	 chroot_scanrealpath;

int	clamderror(const char *, ...);
int	clamdparse(void);
int	clamdlex(void);

%}

%union {
	long number;
	char *string;
}

%token	HOST PORT TRIES TIMEOUT SCANTYPE OPTION
%token	CHROOT_SCANREALPATH FILESYSTEM SOCKET
%token	BIND
%token	<string>	NUMBER
%token	<string>	TEXT

%%
statement	: /* empty */
		| statement '\n'
		| statement host '\n'
		| statement port '\n'
		| statement bind '\n'
		| statement tries '\n'
		| statement timeout '\n'
		| statement scantype '\n'
		| statement option '\n'
		;

host		: HOST '=' TEXT				{
			clamd_host = $3;
		}
		;

port		: PORT '=' NUMBER				{
			const char *errstr;

			clamd_port = strtonum($3, 1, 655535, &errstr);
			if (errstr)
				errx(1, "clamd: port number is %s:%s", errstr, $3);
			free($3);
		}
		;

bind		: BIND '=' TEXT				{
			bind_addr = $3;
		}
		;

tries		: TRIES '=' NUMBER			{
			const char *errstr;

			clamd_tries = strtonum($3, 1, 1024, &errstr);
			if (errstr)
				errx(1, "clamd: number of tries is %s:%s", errstr, $3);
			free($3);
		}
		;
timeout		: TIMEOUT '=' NUMBER			{
			const char *errstr;

			clamd_timeout = strtonum($3, 0, 65535, &errstr);
			if (errstr)
				errx(1, "clamd: timeout is %s:%s", errstr, $3);
			free($3);
		}
		;

scantype	: SCANTYPE '=' FILESYSTEM		{
			scantype = SCANTYPE_FILESYSTEM;
		}
		| SCANTYPE '=' SOCKET			{
			scantype = SCANTYPE_SOCKET;
		}
		;

option		: OPTION '=' CHROOT_SCANREALPATH	{
			chroot_scanrealpath = 1;
		}
		;

%%

int
vilter_init(char *cfgfile)
{
	if (verbose)
		warnx("clamd: vilter_init()");

	/* Default values */

	clamd_port = 3310;
	if ((clamd_host = strdup("localhost")) == NULL)
		errx(1, "clamd: out of memory");
	bind_addr = NULL;
	clamd_tries = 1;
	clamd_timeout = TIMEOUT;
	scantype = SCANTYPE_FILESYSTEM;
	chroot_scanrealpath = 0;

	if (cfgfile == NULL)
		cfgfile = CLAMD_CONF;
	if (verbose)
		warnx("clamd: use config file %s", cfgfile);

	clamdlineno = 1;
	if ((clamdin = fopen(cfgfile, "r")) != NULL) {
		while (!feof(clamdin)) {
			clamdparse();
		}
		fclose(clamdin);
	} else if (verbose)
		warnx("clamd: configuration file %s for clamd backend not found, using default values", cfgfile);

	return 0;
}

int
clamderror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	va_start(ap, fmt);
	if (asprintf(&nfmt, "%d: %s", clamdlineno, fmt) == -1)
		errx(1, "clamd: error asprintf");
	va_end(ap);
	free(nfmt);
	return (0);
}

