%{
/*	$Id: parse.y,v 1.9 2005/04/24 11:24:23 marc Exp $	*/

#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>

#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "smtp-vilter.h"

#if defined(__FreeBSD__) || defined (__linux__)
#include "strtonum.h"
#endif

extern FILE	*vilterin;
extern int	 vilterlineno;
extern char	*viltertext;

extern char	*port;
extern char	*vilterd_host;
extern int	 vilterd_port;
extern int	 virus_strategy;
extern int	 virus_action;
extern int	 spam_strategy;
extern int	 spam_action;
extern int	 unwanted_strategy;
extern int	 unwanted_action;
extern int	 error_strategy;
extern int	 markall;
extern int	 verbose;
extern char	*pidfile;
extern char	*cfgfile;
extern char	*tmpdir;
extern int	 tmpfiles_gr;
extern int	 tmpfiles_setgrp;
extern char	*backend;
extern char	*recipient_notification;
extern char	*notify_only;
extern int	 log_facility;
extern char	*logfile;
extern FILE	*logfp;
extern char	*user;
extern char	*group;
extern char	*chrootdir;
extern int	 rlimit_nofile;
extern int	 nbe;
extern char	*spamprefix;
extern int	 logvirus, logspam, logunwanted;
extern int	 keep_tmpfiles;

extern struct backend	*be;

extern char	*cfgfile;
extern char	*ldaphost;
extern int	 ldapport;
extern char	*searchbase;
extern char	*rulebase;
extern char	*binddn;
extern char	*bindpasswd;
extern int	 ldap_use_tls;

extern int decode_backend(char *);

int	viltererror(const char *, ...);
int	vilterparse(void);
int	vilterlex(void);
%}

%union {
	long	 number;
	char	*string;
}

%token	USER GROUP CHROOT TMPFILES BACKEND CONFIG_FILE
%token	VIRUS_STRATEGY RECIPIENT_NOTIFICATION SPAM_STRATEGY
%token	SPAM_SUBJECT_PREFIX UNWANTED_STRATEGY ERROR_STRATEGY
%token	PORT LOGFILE OPTION NOTIFY_ONLY
%token	DISCARD MARK NOTIFY_RECIPIENT
%token	RJECT TEMPFAIL IGNORE
%token	GRPRD SETGRP CFGFILE PIDFILE TMPDIR MAXFILES MARKALL
%token	LOGVIRUS LOGSPAM LOGUNWANTED LDAP_USE_TLS
%token	LOGFAC LDAPHOST LDAPPORT BINDDN BINDPASSWD SEARCHBASE
%token	USETLS LOCAL0 LOCAL1 LOCAL2 LOCAL3
%token	LOCAL4 LOCAL5 LOCAL6 LOCAL7 TRUE FALSE COMMENT
%token	DAEMON MAIL USER
%token	<string>	NUMBER
%token	<string>	TEXT
%type	<number>	logfac
%type	<number>	v_strategy
%type	<number>	e_strategy
%type	<number>	su_strategy

%%
statement	: /* empty */
		| statement '\n'
		| statement user '\n'
		| statement group '\n'
		| statement chroot '\n'
		| statement tmpfiles '\n'
		| statement backend '\n'
		| statement config_file '\n'
		| statement virus_strategy '\n'
		| statement rcpt_notification '\n'
		| statement notify_only '\n'
		| statement spam_strategy '\n'
		| statement spam_subject_prefix '\n'
		| statement unwanted_strategy '\n'
		| statement error_strategy '\n'
		| statement pidfile '\n'
		| statement port '\n'
		| statement tmpdir '\n'
		| statement maxfiles '\n'
		| statement logfacility '\n'
		| statement logfile '\n'
		| statement option '\n'
		| statement ldaphost '\n'
		| statement ldapport '\n'
		| statement searchbase '\n'
		| statement binddn '\n'
		| statement bindpasswd '\n'
		| statement usetls '\n'
		;

user		: USER '=' TEXT				{
			if (user == NULL)
				user = $3;
			else
				free($3);
		}
		;

group		: GROUP '=' TEXT			{
			if (group == NULL)
				group = $3;
			else
				free($3);
		}
		;

chroot		: CHROOT '=' TEXT			{
			if (chrootdir == NULL)
				chrootdir = $3;
			else
				free($3);
		}
		;

tmpfiles	: TMPFILES '=' GRPRD			{
			tmpfiles_gr = 1;
		}
		| TMPFILES '=' SETGRP			{
			tmpfiles_setgrp = 1;
		}
		;

backend		: BACKEND '=' TEXT			{
			if (backend == NULL)
				decode_backend($3);
			free($3);
		}
		;

config_file	: CFGFILE '=' TEXT			{
			char *be_cfgfile;
			int n;
			int be_found;

			be_cfgfile = strchr($3, ':');
			if (be_cfgfile != NULL) {
				*be_cfgfile++ = '\0';
				be_found = 0;
				for (n = 0; n < nbe; n++) {
					if (!strcmp(be[n].name, $3)) {
						if ((be[n].config_file = strdup(be_cfgfile)) == NULL)
							err(1, "memory allocation error, can't store config file %s for backend %s", be_cfgfile, be[n].name);
						be_found = 1;
						break;
					}
				}
				if (!be_found) {
					warnx("config-file: backend %s not found (hint: config-file commands must be listed after the backend command)", $3);
				}
			} else
				warnx("config-file syntax error");
		}
		;
notify_only	: NOTIFY_ONLY '=' TEXT			{
			notify_only = $3;
		}
		;

rcpt_notification	: RECIPIENT_NOTIFICATION '=' TEXT	{
			recipient_notification = $3;
			}
			;

pidfile		: PIDFILE '=' TEXT			{
			if (pidfile == NULL)
				pidfile = $3;
			else
				free($3);
		}
		;

port		: PORT '=' TEXT				{
			if (port == NULL)
				port = $3;
			else
				free($3);
		}
		;

tmpdir		: TMPDIR '=' TEXT			{
			if (tmpdir == NULL)
				tmpdir = $3;
			else
				free($3);
		}
		;

maxfiles	: MAXFILES '=' NUMBER			{
			long long rlimit_max;
			struct rlimit rl;
			const char *errstr;

			if (rlimit_nofile == -1) {
				if (getuid()) {
					getrlimit(RLIMIT_NOFILE, &rl);
					rlimit_max = rl.rlim_max;
				} else
					rlimit_max = RLIM_INFINITY;
				rlimit_nofile = strtonum(optarg, 1, rlimit_max, &errstr);
				if (errstr)
					errx(1, "maxfiles is %s: %s", errstr, optarg);
			}
			free($3);
		}
		;

logfile		: LOGFILE '=' TEXT			{
			if (logfile == NULL)
				logfile = $3;
			else
				free($3);
		}
		;

virus_strategy	: VIRUS_STRATEGY '=' v_strategy		{
			if (virus_strategy == -1)
				virus_strategy = $3;
		}
		;

v_strategy	: DISCARD		{ $$ = STRATEGY_DISCARD; }
		| MARK			{ $$ = STRATEGY_MARK; }
		| NOTIFY_RECIPIENT	{ $$ = STRATEGY_NOTIFY_RECIPIENT; }
		| RJECT			{ $$ = STRATEGY_REJECT; }
		;

error_strategy	: ERROR_STRATEGY '=' e_strategy		{
			if (error_strategy == -1)
				error_strategy = $3;
		}
		;

e_strategy	: DISCARD		{ $$ = STRATEGY_DISCARD; }
		| MARK			{ $$ = STRATEGY_MARK; }
		| TEMPFAIL		{ $$ = STRATEGY_TEMPFAIL; }
		| IGNORE		{ $$ = STRATEGY_IGNORE; }
		;

spam_strategy	: SPAM_STRATEGY '=' su_strategy		{
			if (spam_strategy == -1)
				spam_strategy = $3;
		}
		;

unwanted_strategy	: UNWANTED_STRATEGY '=' su_strategy		{
			if (unwanted_strategy == -1)
				unwanted_strategy = $3;
		}
		;
su_strategy	: DISCARD		{ $$ = STRATEGY_DISCARD; }
		| MARK			{ $$ = STRATEGY_MARK; }
		| RJECT			{ $$ = STRATEGY_REJECT; }
		;

spam_subject_prefix	: SPAM_SUBJECT_PREFIX '=' TEXT	{
			if (spamprefix == NULL)
				spamprefix = $3;
			else
				free($3);
		}
		;

option		: OPTION '=' MARKALL			{
			markall = 1;
		}
		| OPTION '=' LOGVIRUS			{
			logvirus = 1;
		}
		| OPTION '=' LOGSPAM			{
			logspam = 1;
		}
		| OPTION '=' LOGUNWANTED		{
			logunwanted = 1;
		}
		| OPTION '=' LDAP_USE_TLS		{
			ldap_use_tls = 1;
		}
		;

ldaphost	: LDAPHOST '=' TEXT			{
			if (ldaphost == NULL)
				ldaphost = $3;
			else
				free($3);
		}
		;

ldapport	: LDAPPORT '=' NUMBER			{
			if (ldapport == -1) {
				const char *errstr;
			
				ldapport = strtonum($3, 1, 65535, &errstr);
				if (errstr)
					errx(1, "port number is %s: %s", errstr, $3);

				free($3);
			}
		}
		;

searchbase	: SEARCHBASE '=' TEXT		{
			if (searchbase == NULL)
				searchbase = $3;
			else
				free($3);
		}
		;


binddn		: BINDDN '=' TEXT		{
			if (binddn == NULL)
				binddn = $3;
			else
				free($3);

		}
		;

bindpasswd	: BINDPASSWD '=' TEXT		{
			if (bindpasswd == NULL)
				bindpasswd = $3;
			else
				free($3);
		}
		;

logfacility	:	LOGFAC '=' logfac	{
				log_facility = $3;
		}
		;

logfac		:	LOCAL0		{ $$ = LOG_LOCAL0; }
		|	LOCAL1		{ $$ = LOG_LOCAL1; }
		|	LOCAL2		{ $$ = LOG_LOCAL2; }
		|	LOCAL3		{ $$ = LOG_LOCAL3; }
		|	LOCAL4		{ $$ = LOG_LOCAL4; }
		|	LOCAL5		{ $$ = LOG_LOCAL5; }
		|	LOCAL6		{ $$ = LOG_LOCAL6; }
		|	LOCAL7		{ $$ = LOG_LOCAL7; }
		|	DAEMON		{ $$ = LOG_DAEMON; }
		|	MAIL		{ $$ = LOG_MAIL; }
		|	USER		{ $$ = LOG_USER; }
		;
	
usetls		: USETLS '=' TRUE		{
			if (ldap_use_tls == -1)
				ldap_use_tls = 1;
		}
		| USETLS '=' FALSE		{
			if (ldap_use_tls == -1)
				ldap_use_tls = 0;
		}
		;
%%

void
smtp_vilter_init(void)
{
	vilterlineno = 1;
	if ((vilterin = fopen(cfgfile, "r")) != NULL) {
		while (!feof(vilterin)) {
			vilterparse();
		}
		fclose(vilterin);
	}
}

int
viltererror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	va_start(ap, fmt);
	if (asprintf(&nfmt, "%s:%d: %s", cfgfile, vilterlineno, fmt) == -1)
		errx(1, "viltererror asprintf");
	va_end(ap);
	free(nfmt);
	return (0);
}

