%{
/*	$Id: parse.y,v 1.9 2005/04/24 11:51:19 marc Exp $	*/

#include <sys/types.h>
#if defined(__OpenBSD__)
#include <sys/limits.h>
#endif

#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "smtp-vilter.h"
#include "pathnames.h"

#if defined(__FreeBSD__) || defined(__linux__)
#include "strtonum.h"
#endif

extern FILE	*spamdin;
extern int	 spamdlineno;
extern char	*spamdtext;

extern int	 spamd_port;
extern char	*spamd_host;
extern char	*bind_addr;
extern int	 spamd_tries;
extern int	 spamd_timeout;
extern off_t	 spamd_maxsize;

int	spamderror(const char *, ...);
int	spamdparse(void);
int	spamdlex(void);
%}

%union {
	long number;
	char *string;
}

%token	HOST PORT TRIES TIMEOUT MAXSIZE BIND
%token	<string>	NUMBER
%token	<string>	TEXT

%%
statement	: /* empty */
		| statement '\n'
		| statement host '\n'
		| statement port '\n'
		| statement bind '\n'
		| statement tries '\n'
		| statement timeout '\n'
		| statement maxsize '\n'
		;

host		: HOST '=' TEXT				{
			spamd_host = $3;
		}
		;

port		: PORT '=' NUMBER			{
			const char *errstr;

			spamd_port = strtonum($3, 1, 65535, &errstr);
			if (errstr)
				errx(1, "port number is %s:%s", errstr, $3);
			free($3);
		}
		;

bind		: BIND '=' TEXT				{
			bind_addr = $3;
		}
		;

tries		: TRIES '=' NUMBER			{
			const char *errstr;

			spamd_tries = strtonum($3, 1, 1024, &errstr);
			if (errstr)
				errx(1, "number of tries is %s:%s", errstr, $3);
			free($3);
		}
		;
timeout		: TIMEOUT '=' NUMBER			{
			const char *errstr;

			spamd_timeout = strtonum($3, 0, 65535, &errstr);
			if (errstr)
				errx(1, "timeout is %s:%s", errstr, $3);
			free($3);
		}
		;

maxsize		: MAXSIZE '=' NUMBER			{
			const char *errstr;

			spamd_maxsize = strtonum($3, 0, LLONG_MAX, &errstr);
			if (errstr)
				errx(1, "maxsize is %s:%s", errstr, $3);
			free($3);
		}
		;
%%

int
vilter_init(char *cfgfile)
{
	if (verbose)
		warnx("spamd: vilter_init()");

	/* Default values */

	spamd_port = 783;
	if ((spamd_host = strdup("localhost")) == NULL)
		err(1, "spamd: out of memory");
	spamd_tries = 1;
	spamd_timeout = TIMEOUT;
	spamd_maxsize = 0;
	bind_addr = NULL;

	if (cfgfile == NULL)
		cfgfile = SPAMD_CONF;

	spamdlineno = 1;
	if ((spamdin = fopen(cfgfile, "r")) != NULL) {
		while (!feof(spamdin)) {
			spamdparse();
		}
		fclose(spamdin);
	} else if (verbose)
		warnx("spamd: configuration file %s for spamd backend not found, using default values", cfgfile);

	return 0;
}

int
spamderror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	va_start(ap, fmt);
	if (asprintf(&nfmt, "%d: %s", spamdlineno, fmt) == -1)
		errx(1, "spamderror asprintf");
	va_end(ap);
	free(nfmt);
	return (0);
}

