%{
/*	$Id: parse.y,v 1.8 2005/04/24 11:51:19 marc Exp $	*/

#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "smtp-vilter.h"
#include "pathnames.h"

#if defined(__FreeBSD__) || defined(__linux__)
#include "strtonum.h"
#endif

#define MAXTRIES	256

extern FILE	*savsein;
extern int	 savselineno;
extern char	*savsetext;

extern int	 savse_port;
extern char	*savse_host;
extern char	*bind_addr;
extern int	 savse_tries;
extern int	 savse_timeout;
extern int	 chroot_scanrealpath;

int	savseerror(const char *, ...);
int	savseparse(void);
int	savselex(void);
%}

%union {
	long number;
	char *string;
}

%token	HOST PORT BIND TRIES TIMEOUT OPTION CHROOT_SCANREALPATH
%token	<string>	NUMBER
%token	<string>	TEXT

%%
statement	: /* empty */
		| statement '\n'
		| statement host '\n'
		| statement port '\n'
		| statement bind '\n'
		| statement tries '\n'
		| statement timeout '\n'
		| statement option '\n'
		;

host		: HOST '=' TEXT				{
			savse_host = $3;
		}
		;

port		: PORT '=' NUMBER			{
			const char *errstr;

			savse_port = strtonum($3, 1, 65535, &errstr);
			if (errstr)
				errx(1, "port number is %s:%s", errstr, $3);
			free($3);
		}
		;

bind		: BIND '=' TEXT				{
			if (bind_addr != NULL)
				free(bind_addr);
			bind_addr = $3;
		}
		;

tries		: TRIES '=' NUMBER			{
			const char *errstr;

			savse_tries = strtonum($3, 1, MAXTRIES, &errstr);
			if (errstr)
				errx(1, "number of tries is %s:%s", errstr, $3);
			free($3);
		}
		;
timeout		: TIMEOUT '=' NUMBER			{
			const char *errstr;

			savse_timeout = strtonum($3, 0, 65535, &errstr);
			if (errstr)
				errx(1, "timeout is %s:%s", errstr, $3);
			free($3);
		}
		;

option		: OPTION '=' CHROOT_SCANREALPATH	{
			chroot_scanrealpath = 1;
		}
		;

%%

int
vilter_init(char *cfgfile)
{
	if (verbose)
		warnx("savse: vilter_init()");

	/* Default values */

	savse_port = 7777;
	if ((savse_host = strdup("localhost")) == NULL)
		err(1, "savse: out of memory");
	savse_tries = 1;
	savse_timeout = TIMEOUT;
	chroot_scanrealpath = 0;
	bind_addr = NULL;

	if (cfgfile == NULL)
		cfgfile = SAVSE_CONF;

	savselineno = 1;
	if ((savsein = fopen(cfgfile, "r")) != NULL) {
		while (!feof(savsein)) {
			savseparse();
		}
		fclose(savsein);
	} else if (verbose)
		warnx("clamd: configuration file %s for clamd backend not found, using default values", cfgfile);

	return 0;
}

int
savseerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	va_start(ap, fmt);
	if (asprintf(&nfmt, "%d: %s", savselineno, fmt) == -1)
		errx(1, "savseerror asprintf");
	va_end(ap);
	free(nfmt);
	return (0);
}

