/*
 * Copyright (c) 2003, 2004 Marc Balmer <marc@msys.ch>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __SMTP_VILTER__
#define __SMTP_VILTER__

#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

#define	VERSION	"1.1.8"

#define MAJOR		5			/* Major and minor version number */
#define MINOR		0			/* of shared libs (backends) */

/*
	The following values define reasons why an email might be rejected,
	they also define the three possible types of backends.
*/

#define SCAN_OK			0	/* Message is acceptable */
#define SCAN_VIRUS		1	/* Message contains a virus */
#define SCAN_SPAM		2	/* Message is considered spam */
#define SCAN_UNWANTED	3	/* Unwanted content, eg. attachement */
							/* of a certain type */
#define SCAN_ERROR 		-1

struct be_data {
	struct syslog_data *sdata;
	void *priv;
};

struct token {
	char *string;
	int token;		/* This must not be TOK_UNKNOWN in tables */
};

#define SOCK_BUFSIZE	1024

typedef struct SOCK {
	int sock;	
	char buf[SOCK_BUFSIZE];
	int size;
	int pos;
} SOCK;

#define TOK_UNKNOWN	(-1)

extern int verbose;

extern int read_conf(FILE *fp, char *f, int fl, char *v, int vl);

extern SOCK *fdsock(int fd);
extern char *sgets(char *s, int size, SOCK *sock, struct timeval *timeout);
extern void sclose(SOCK *s);

extern ssize_t to_recv(int s, void *buf, size_t len, int flags, struct timeval *timeout);
extern ssize_t to_send(int s, void *buf, size_t len, int flags, struct timeval *timeout);

extern int get_token(struct token *token_tab, char *string, int deflt);

#endif
