#!/bin/sh

if ! PREFIX=$(/bin/expr $0 : "\(/.*\)/etc/rc\.d/${0##*/}\$"); then
        echo "$0: Cannot determine the PREFIX" >&2
        exit 64
fi

BIN_DIR="/usr/local/sbin"

DAEMON="clamd"
DAEMON_HOME="${PREFIX}/clamav"
DAEMON_CONF="${PREFIX}/etc/clamav.conf"
DAEMON_FLAG="-c ${DAEMON_CONF}"
DAEMON_PORT="local:/var/run/clamav/clamav.sock"

MILTER="smtp-vilter"
MILTER_FLAG="-C /usr/local/etc/smtp-vilter/smtp-vilter.conf" 
MILTER_PORT="-p local:/var/run/clamav/smtp-vilter.sock"

# MILTER="/usr/local/sbin/clamav-milter"
# MILTER_FLAG="-l -o -P" 
# MILTER_PORT="local:/var/run/clamav/clmilter.sock"

case "$1" in
start)
	rm -rf /var/run/clamav/*
	${BIN_DIR}/${DAEMON} ${DAEMON_FLAG}
	sleep 5
	${BIN_DIR}/${MILTER} ${MILTER_FLAG} ${MILTER_PORT} 
	echo -n ' clamav milter'
	;;
stop)
	killall -TERM ${DAEMON}
	killall -TERM ${MILTER}
	echo -n ' clamav-milter'
	;;
*)
	echo "Usage: `basename $0` {start|stop}" >&2
	;;
esac

exit 0
