/*
 * Copyright (c) 2003, 2004 Marc Balmer <marc@msys.ch>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/param.h>	/* For the howmany macro */
#include "smtp-vilter.h"

ssize_t
to_recv(int s, void *buf, size_t len, int flags, struct timeval *timeout)
{
	fd_set *fdsr;
	int max = s;
	int n;
	
	fdsr = (fd_set *) calloc(howmany(max + 1, NFDBITS), sizeof(fd_mask));
	
	if (fdsr == NULL)
		return -1;
	
	FD_SET(s, fdsr);
	
	n = select(max + 1, fdsr, NULL, NULL, timeout);
	
	free(fdsr);
	
	bzero(buf, len);
	
	if (n > 0)
		return recv(s, buf, len, flags);

	return n;
}

ssize_t
to_send(int s, void *buf, size_t len, int flags, struct timeval *timeout)
{
	fd_set *fdsr;
	int max = s;
	int n;
	
	fdsr = (fd_set *) calloc(howmany(max + 1, NFDBITS), sizeof(fd_mask));
	
	if (fdsr == NULL)
		return -1;
	
	FD_SET(s, fdsr);
	
	n = select(max + 1, NULL, fdsr, NULL, timeout);
	
	free(fdsr);
	
	if (n > 0)
		return send(s, buf, len, flags);

	return n;
}

SOCK *
fdsock(int sock)
{
	SOCK *sp;
	
	sp = calloc(sizeof(SOCK), 1);
	
	if (sp != NULL) {
		sp->sock = sock;
	}
	
	return sp;
}

char *
sgets(char *str, int size, SOCK *sock, struct timeval *to)
{
	char *src, *p;
	int nbytes = 0;
	
	if (sock->size == 0) {
		sock->pos = 0;
		
		sock->size = to_recv(sock->sock, sock->buf, SOCK_BUFSIZE, 0, to);
				
		if (sock->size == -1)
			return NULL;
	}
	
	/* find a cr or lf */
	
	for (src = p = &sock->buf[sock->pos]; size > 0 && sock->pos < sock->size && *p != '\r' && *p != '\n'; sock->pos++, p++, nbytes++, size--)
		;
	
	/* Move past the end of line */
	
	while (size > 0 && sock->pos < sock->size && (*p == '\r' || *p == '\n')) {
		++nbytes;
		++sock->pos;
		--size;
	}
			
	strncpy(str, src, nbytes);
	str[nbytes] = '\0';
	sock->size -= nbytes;
	
	return str;
}

void
sclose(SOCK *s)
{
	close(s->sock);
	free(s);
}


