#include <stdio.h>
#include <stdlib.h>
#ifdef linux
#include <string.h>
#endif
#include <strings.h>
#include <sys/types.h>
#include <signal.h>
#include <pcap.h>
#include <netinet/in.h> 
#ifdef solaris
#define u_int8_t uint8_t
#define u_int16_t uint16_t
#define u_int32_t uint32_t
#endif
#include "ip.h"         /* modif from the linux netinet/ip.h          */ 
#include "tcp.h"        /* modif from the linux netinet/tcp.h         */
                        /* used local struct for means of portability */
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/socket.h>
#include <arpa/inet.h>

#include "smb.h"

#define FILTER				"src port 139 or dst port 139"
#define SNAP_LEN			1514
#define SMB_PORT			139
#define CMD_OFFSET                      9
#define NAME_SIZE                       255
#define PTR_NB                          1024 

/* from the byteorder.h of samba */
#define CVAL(buf,pos) (((unsigned char *)(buf))[pos])
#define PVAL(buf,pos) ((unsigned)CVAL(buf,pos))
#define extract_int(buf,pos) (PVAL(buf,pos+1)|PVAL(buf,(pos))<<8)
#define extract_int2(buf,pos) (PVAL(buf,pos)|PVAL(buf,(pos+1))<<8)
#define SVAL(buf,pos) (PVAL(buf,pos)|PVAL(buf,(pos)+1)<<8)
#define extract_long(buf,pos) (SVAL(buf,pos)|SVAL(buf,(pos)+2)<<16)

#define min(a,b) ((a<b)?a:b)


void (* ptr [255])(u_char *,u_int);
/* function pointer array to the SMB commands                 */
/* commands are listed by the hex value of their command code */

/* Follow session structure                                               */
/* struct to save the name of the file to write to and @ and port numbers */
/* of the session transmitting the file                                   */
/* this struct is used to follow sessions and put the raw data received   */
/* in the correct file                                                    */

struct connexion_info {
  char name[NAME_SIZE];
  u_int32_t addr1;
  u_int32_t addr2;
  u_int16_t port1;
  u_int16_t port2;
  int fid;
  u_int32_t  offset;
  int read_flag;
  int ntcreatex;
} cnx[PTR_NB];


int last_fid;
int idcnx;   /* number of cnx field currently used */
int ok;      /* needed to prevent havoc when receiving multiple open request */
int ignore;  /* used besause sometimes we have to ignore data 
               (when multiple reply for the same request occur) */


int is_connexion(int fid)
{
  int i=0;
  
  while(i<=idcnx)
    {
      if  (cnx[i].fid==fid) 
	{
	  return(i);
	}
      i++;
    }
  return(-1);
}

/***************************************************************/
/* Generic open function / used to prevent from rewritting the 
   open code in the And X commands
   rr  0 = request 1 = reply
   int file_handle
   char *name
                                                               */
/***************************************************************/
void generic_open(struct iphdr *ip_hdr,
		  struct tcphdr *tcp_hdr,
		  u_char * name,
		  int fid)
{
  char msg[300];
  int fd,i;
  u_char file_name[NAME_SIZE];

  /* 
     It would be a good idea to replace all special characters in
     the file name (such as "space" or "/") with another character
  */
	  
  if(name[0]=='\\')
    name+=1;
  
  for(i=0;i<NAME_SIZE;i++) /* I chose to replace \ and space with .  */
    {                      /* If you want to change it suit yourself */
      if(name[i]== '\\' )
	name[i]='.';
      else		
	if(name[i]==' ')
	  name[i]='.';
    }
      
  memcpy(file_name,name,NAME_SIZE);
  ok++;	
      
  snprintf(msg,5,"-%d",rand()%1000);	 
  strcat(file_name,msg); 
		
  if(idcnx<PTR_NB)
    {
      fd=open(file_name, 
	      O_CREAT | O_RDWR , 
	      0666);
      if(fd>=0)
	{
	  close(fd);
	  idcnx++;
	  memcpy(cnx[idcnx].name,
		 file_name,
		 sizeof(file_name));
	  cnx[idcnx].addr1=ip_hdr->saddr;
	  cnx[idcnx].addr2=ip_hdr->daddr;
	  cnx[idcnx].port1=tcp_hdr->source;
	  cnx[idcnx].port2=tcp_hdr->dest;
	  cnx[idcnx].read_flag=0;
	  cnx[idcnx].ntcreatex=0;
	  cnx[idcnx].offset=0;
	  cnx[idcnx].fid=fid;
	  last_fid=fid;

	}
      else
	{
	  puts("error creating file");
	}
      bzero(file_name,NAME_SIZE);
    }
  else
    {
      puts("struct full cannot open anymore files");
    }
}

/***************************************************************/
/* Generic Write
                                                               */
/***************************************************************/
void generic_write(int fid, uint32_t d_size, u_char * buff)
{
  int fd,found;
  off_t tmp;

  if ( (found=is_connexion(fid)) >=0 )
    {

      if((fd=open(cnx[found].name, O_RDWR))>=0)
	{
	  tmp=lseek(fd,(off_t)(cnx[found].offset),SEEK_SET);
	  if(tmp==(off_t)(cnx[found].offset))
	    {
	      write(fd,buff,d_size);
	      close(fd);
	      //printf("Generic write : offset was %d   +++++      d_size is %d\n",cnx[found].offset,(uint32_t)(d_size));
	      cnx[found].offset+=(uint32_t)(d_size);
	      //printf("Generic write : offset is %d\n",cnx[found].offset);
	      cnx[found].read_flag++; 	     
	    }
	  else
	    {
	      printf("\nIn Generic Write : error with lseek tmp = %d offset = %d \n",(int)(tmp),cnx[found].offset);
	      
	    }
	}	      
    }
  else
    {
      puts("generic write : fid not found -> not logged");
    }  
}


/************************************************************/
/* Tree Connect And X
   open and read commands might be embedded                 */
/************************************************************/ 
void smbtreecntX(u_char *buff, u_int off)
{
  struct smbhdr *smb_hdr;
  u_int off1,off2;
  
  struct iphdr *ip_hdr;    /* netinet ip header struct  */
  struct tcphdr *tcp_hdr;  /* netinet tcp header struct */
  
  smb_hdr=(struct smbhdr *)(buff+4);
  ip_hdr=(struct iphdr *)(buff-off);
  tcp_hdr=(struct tcphdr *)(buff-off+(ip_hdr->ihl*4));

  if((smb_hdr->flag&128)==128)
    {
      if(buff[4+sizeof(struct smbhdr)]!=0xFF)
	{
	  if(buff[4+sizeof(struct smbhdr)]==0x02)
	    {
	      /* open */
	    }
	  if(buff[4+sizeof(struct smbhdr)]==0x2D)
	    {
	      /* open X  */
	      if( buff[4+off1+2] != 0xFF) /* Is their another command */
		    {
		      if( buff[4+off1+2] == 0x2E )
			{
			  /* READ And X */
			  puts("Tree connect X : Read and X  : not implemented");
			}
		      if( buff[4+off1+1] == 0x0A)
			{ 
			  /* READ */
			  puts("Tree connect X : Read : not implemented");
			}
		    }
	    }	      
	}
    }
  else
    {
      if(buff[4+sizeof(struct smbhdr)]==0xFF)
	{
	  //strncat(msg,"no secondary request",21);
	}
      else
	{
	  //strncat(msg,"secondary command : ",21); 
	
	  if(buff[4+sizeof(struct smbhdr)]==0x02)
	    {	
	      /* OPEN */ 
	    }
	  if(buff[4+sizeof(struct smbhdr)]==0x2D)
	    {
	      /* OPEN X*/
	      if( buff[4+off1+1] != 0xFF)
		{/* another command */
		  off2=extract_int(buff,4+off1+3);
		
		  if(buff[4+off1+1]==0x2E)
		    {
		      /* Read and X */
		    }
		  if(buff[4+off1+1]==0x0A)
		    {
		      /* Read */
		    }
		}
	    }
	}
    }
}  

/******************************************************/
/* Open And X command
   In the request grab the file name
   In the reply grab the file descriptor
   Create a new entry in the follow session structure
   Create the file to write data into                 
   Sorry no And X treatment Yet                       */
/******************************************************/

void smbopenx(u_char *buff, u_int off)
{
  struct smbhdr *smb_hdr;
  u_int i,j,off1,off2;
  int found;
  int fid;
  static char name[NAME_SIZE];

  struct iphdr *ip_hdr;    /* netinet ip header struct  */
  struct tcphdr *tcp_hdr;  /* netinet tcp header struct */
  
  smb_hdr=(struct smbhdr *)(buff+4);
  ip_hdr=(struct iphdr *)(buff-off);
  tcp_hdr=(struct tcphdr *)(buff-off+(ip_hdr->ihl*4));
  
  if((smb_hdr->flag&128)==128)
    {
      //if ( smb_hdr->rcls!=0)
      //puts("Error in open X");
      //else
      if ( smb_hdr->rcls == 0)
	{
          off2=4+sizeof(struct smbhdr)+4; /* offset to FID */
	  fid=extract_int(buff,off2);

	  generic_open(ip_hdr,tcp_hdr,name,fid);
	  bzero(name,NAME_SIZE);
	  
	  if((found=is_connexion(fid))>=0)
	    cnx[found].ntcreatex=1;
	  
	  if(buff[sizeof(struct smbhdr)+4]==0x2E)
	    {
	      puts("OpenX : Read X not implemented");
	      /* READ and X -> reply */
	    }
	  if(buff[sizeof(struct smbhdr)+4]==0x0A)
	    {
	      puts("OpenX : Read not implemented");
	      /* READ  */
	    }
	  if(buff[sizeof(struct smbhdr)+4]==0xFF)
	    {
	      /* NONE */
	    }
	} 	 
    }
  else
    {

      if((smb_hdr->flag2[1]&0x127)==1)
	{  /* User string is Unicode */
	    i=4 + sizeof(struct smbhdr) + 32 +1; 
	    j=0;
	  
	    
	    while(1)
	      {
		if(buff[i]==0x00)
		  if(buff[i+1]==0x00) break;
		name[j]=buff[i];
		j++;
		name[j]='\0';
		i+=2;
	      }
	}
      else
	{
	  i=4 + sizeof(struct smbhdr) + 32 +1; 
	  j=0;
	  
	  while(j<NAME_SIZE)
	    {
	      name[j]=buff[i+j];
	      if(name[j]=='\0')
		break;
	      j++;
	    }
	  name[j]='\0';
	}

      off1=extract_int2(buff,4+sizeof(struct smbhdr)+2);
      /* offset of the next command */
      
      if(buff[sizeof(struct smbhdr)+4]==0x2E)
	{ 
	  /* READ and X  */ 
	}
      if(buff[sizeof(struct smbhdr)+4]==0x0A)
	{  
	  /* READ */
	}
      
      if(buff[sizeof(struct smbhdr)+4]==0xFF)
	{
	  /* NONE */
	}
    }
}


/***************************************************/
/* Close command 
   Delete the entry in the session descriptor used */
/***************************************************/

void smbclose(u_char *buff, u_int off)
{
  struct smbhdr *smb_hdr;
  u_int j;
  int found=-1;
  static int fid;
  struct iphdr *ip_hdr;    
  struct tcphdr *tcp_hdr; 
  
  ip_hdr=(struct iphdr *)(buff-off);
  tcp_hdr=(struct tcphdr *)(buff-off+(ip_hdr->ihl*4));  
  smb_hdr=(struct smbhdr *)(buff+4);
  
  if((smb_hdr->flag&128)==128)
    { /* Reply */
      if(idcnx>=0)  
	{	  
	  if( (found=is_connexion(fid)) >=0 )
	    {
	      if(found==idcnx) /* Only one entry in cnx */
		{
		  idcnx--;
		  bzero(cnx[found].name,NAME_SIZE);
		  cnx[found].offset=0;
		  cnx[found].read_flag=0;
		}
	      else
		{ /* reorganise the cnx table */
		  for(j=found;j<idcnx-1;j++)
		    {
		      strncpy(cnx[j].name,cnx[j+1].name,NAME_SIZE);	      
		      cnx[j].addr1=cnx[j+1].addr1;
		      cnx[j].addr2=cnx[j+1].addr2;
		      cnx[j].port1=cnx[j+1].port1;
		      cnx[j].port2=cnx[j+1].port2;
		      cnx[j].offset=cnx[j+1].offset;
		      cnx[j].read_flag=cnx[j+1].read_flag;
		    }
		  idcnx--;
		}
	    }
	}

    }
  else
    {
      fid=extract_int(buff,4+sizeof(struct smbhdr));
    }
}


/*******************************************************
 Write And X command

*******************************************************/
void smbwritex(u_char *buff, u_int off)
{

  struct smbhdr *smb_hdr;
  int k,j,w,fid,t;
  int debut;
  

  struct iphdr *ip_hdr;    /* netinet ip header struct  */
  struct tcphdr *tcp_hdr;  /* netinet tcp header struct */
  
  smb_hdr=(struct smbhdr *)(buff+4);
  ip_hdr=(struct iphdr *)(buff-off);
  tcp_hdr=(struct tcphdr *)(buff-off+(ip_hdr->ihl*4));

  if((smb_hdr->flag&128)!=128)
    {

      debut=extract_int2(buff,4+sizeof(struct smbhdr)+22);
      if(debut!=0)/* If their is really data to write*/
	{
	  fid=extract_int(buff,4+sizeof(struct smbhdr)+4);

	  w=extract_long(buff,4+sizeof(struct smbhdr)+6);

	  if(buff[4+sizeof(struct smbhdr)]!=0xFF)
	    {
	      k=extract_int2(buff,sizeof(struct smbhdr)+4+2);
	      j=k-debut;
	    }
	  else
	    {
#ifdef solaris
	      j=ip_hdr->tot_len-(ip_hdr->ihl*4)-(tcp_hdr->doff*4)-4-debut;
#else
	      j=htons(ip_hdr->tot_len)-(ip_hdr->ihl*4)-(tcp_hdr->doff*4)-4-debut;
#endif
	    }
	  
	  if((t=is_connexion(fid))>=0)
	    {
	      if(cnx[t].offset!=w)
		{
		  printf("Write X : offset corrected file %s will be wrong\n",cnx[t].name);
		  cnx[t].offset=w;
		}
	  
	    }
	  generic_write(fid,j,buff+4+debut);
      
	  if(is_connexion(fid)>=0)
	    {
	      if(cnx[is_connexion(fid)].ntcreatex==1)
		cnx[is_connexion(fid)].read_flag=0;
	      
	      last_fid=fid;
	    }
	}
   }  

}

/*******************************************************/
/* Read and X command
   In fact it doesn't really treat the and X but ...
                                                       */
/*******************************************************/

void smbreadx(u_char *buff, u_int off)
{
  struct smbhdr *smb_hdr;
  struct iphdr *ip_hdr; 
  struct tcphdr *tcp_hdr;
  int debut,k,t;
  uint32_t j;
  static uint32_t fid;
  static uint32_t w,req;
  
  smb_hdr=(struct smbhdr *)(buff+4);
  ip_hdr=(struct iphdr *)(buff-off);
  tcp_hdr=(struct tcphdr *)(buff-off+(ip_hdr->ihl*4));
  
  if((smb_hdr->flag&128)==128)
    { 
      if(smb_hdr->rcls==0x0) /* if no error */
	{
	  debut=extract_int2(buff,4+sizeof(struct smbhdr)+12);
	   if(debut!=0)/* If their is really data to write*/
	     {
	       if(buff[4+sizeof(struct smbhdr)]!=0xFF)
		 {
		   k=extract_int2(buff,sizeof(struct smbhdr)+4+2);
		   j=k-debut;
		 }
	       else
		 {
#ifdef solaris
		   j=ip_hdr->tot_len-(ip_hdr->ihl*4)-(tcp_hdr->doff*4)-4-debut;
#else
		   j=(int)(htons(ip_hdr->tot_len)-(ip_hdr->ihl*4)-(tcp_hdr->doff*4)-4-debut);
#endif
		 }
	       
	       if((t=is_connexion(fid))>=0)
		 {
		   if(req==1)
		     {
		       if(cnx[t].offset!=w)
			 {
			   
			   printf("Read X : offset corrected - file will %s will be wrong\n",cnx[t].name);
			   printf("offset read : %d     offset stored : %d\n",w,cnx[t].offset);
			   cnx[t].offset=w;
			 }
		     }
		   //printf("call to generic write in READX, j is %d\n",j);
		   generic_write(fid,j,buff+debut+4);
	       
		   last_fid=fid;
		   if(cnx[is_connexion(fid)].ntcreatex==1)
		     cnx[is_connexion(fid)].read_flag=0;
		 }
	     }
	}
      req=0;
    }
  else
    {
      fid=extract_int(buff,4+sizeof(struct smbhdr)+4);
      w=extract_long(buff,4+sizeof(struct smbhdr)+6);
      //printf("extract long offset = %d\n",w);
      if(buff[4+sizeof(struct smbhdr)]!=0xFF)
	{
	  puts("other function in readx : not implemented");
	}
      req=1;
    }
}

/*****************************************************************/
/* SMB NT create and X
 */
/*****************************************************************/

void smbntcreatex(u_char *buff,u_int off)
{
  struct smbhdr *smb_hdr;
  static u_char name[NAME_SIZE];
  int i,fid,ln,j,k=0;
  
  struct iphdr *ip_hdr;    /* netinet ip header struct  */
  struct tcphdr *tcp_hdr;  /* netinet tcp header struct */
  
  smb_hdr=(struct smbhdr *)(buff+4);
  ip_hdr=(struct iphdr *)(buff-off);
  tcp_hdr=(struct tcphdr *)(buff-off+(ip_hdr->ihl*4));
  
  /* No readX and read management ...  yet  */

  if((smb_hdr->flag&128)==128)
    { 
      if(smb_hdr->rcls==0x0) /* if no error */
	{
	  /* Extract FID */
	  fid=extract_int(buff,4+sizeof(struct smbhdr)+5);
	  
	  generic_open(ip_hdr,tcp_hdr,name,fid);
	  if((i=is_connexion(fid))>=0)
	    cnx[i].ntcreatex=1;
	  bzero(name,NAME_SIZE);
	}
    }
  else
    {
      if((smb_hdr->flag2[1]&0x127)==1)
	{  /* User string is Unicode */
	    i=4 + sizeof(struct smbhdr) + 50 +1; 
	    k=0;
	  
	    
	    while(1)
	      {
		if(buff[i]==0x00)
		  if(buff[i+1]==0x00) break;
		name[k]=buff[i];
		name[k+1]='\0';
		k++;
		i+=2;
	      }
	}
      else
	{
	  ln=extract_int2(buff,4+sizeof(struct smbhdr)+5);
	  if(ln>0)
	    {
	      k=0;
	      i=4+sizeof(struct smbhdr)+50;
	      for(j=0;j<ln;j++)
		{
		  if(buff[j+i]!='\0')
		    {
		      name[k]=buff[j+i];
		      k++;
		    }
		}
	      name[k]='\0';
	    }
	}
    }
}
/******************************************************************/
void smbwrite(u_char *buff, u_int off)
{
 struct smbhdr *smb_hdr;
  int j,fid,t;
  int debut;
 
  struct iphdr *ip_hdr;    /* netinet ip header struct  */
  struct tcphdr *tcp_hdr;  /* netinet tcp header struct */
  
  smb_hdr=(struct smbhdr *)(buff+4);
  ip_hdr=(struct iphdr *)(buff-off);
  tcp_hdr=(struct tcphdr *)(buff-off+(ip_hdr->ihl*4));

  if((smb_hdr->flag&128)!=128)
    {
      debut=extract_int2(buff,4+sizeof(struct smbhdr)+10);
      if(debut!=0)/* If their is really data to write*/
	{
	  fid=extract_int(buff,4+sizeof(struct smbhdr));
#ifdef solaris
	  j=ip_hdr->tot_len-(ip_hdr->ihl*4)-(tcp_hdr->doff*4)-4-10;
#else
	  j=htons(ip_hdr->tot_len)-(ip_hdr->ihl*4)-(tcp_hdr->doff*4)-4-10;
#endif	  
	  if((t=is_connexion(fid))>=0)
	    {

	      //if(cnx[t].offset!=w)
	      //{
	      //  printf("Write X : offset corrected file %s will be wrong\n",cnx[t].name);
	      //  cnx[t].offset=w;
	      //}
	      last_fid=fid;
	    }
	}
    }
}
	  

void smbread(u_char *buff, u_int off)
{
  puts("smbread not implemented");
}

void smbwritebraw(u_char *buff, u_int off)
{
  puts("smb write block raw not implemented");
}

void smbreadbraw(u_char *buff, u_int off)
{
  puts("smb read block raw not implemented");
}

void smbopenspool(u_char *buff, u_int off)
{
  puts("smb open spool not implemented");
}

void smbwritespool(u_char *buff, u_int off)
{
  puts("smb write spool not implemented");
}

void smbclosespool(u_char *buff, u_int off)
{
  puts("smb close spool not implemented");
}





/******************************************************************/
void smbcmd(u_char *buff, u_int off)
{
  struct smbhdr *smb_hdr;
  //char msg[255];
  
  smb_hdr=(struct smbhdr *)(buff+4);
  
  //snprintf(msg,15,"SMB command %x",smb_hdr->com);
  if((smb_hdr->flag&128)==128)
    { 
      //strncat(msg," reply",6);
      //puts(msg);
      //puts("");
    }
  else
    {
      //strncat(msg," request",8);
      //puts(msg);
    }    
}


/*****************************************************************/
/* fill the pointer table with the corresponding function        
   each function is identified by it's smb command number        */
/*****************************************************************/

void init_ptr()
{
int i;

for (i=0; i<=255; i++)
  ptr[i]=smbcmd;

ptr[0x2D]=smbopenx;
ptr[0xA2]=smbntcreatex;
ptr[0x04]=smbclose;

ptr[0x2E]=smbreadx;
ptr[0x2F]=smbwritex;


ptr[0x0B]=smbwrite;
ptr[0x1D]=smbwritebraw;

ptr[0xC0]=smbopenspool;
ptr[0xC1]=smbwritespool;
ptr[0xC2]=smbclosespool;

ptr[0x75]=smbtreecntX;

ptr[0x0A]=smbread;
ptr[0x1A]=smbreadbraw;

}

/*********************************************************************/
/* Check wether the packet transmitted is a smb command or raw data 
   If the packet contains a smb command call the apropriate function
   to process it.
   Save the data transmitted if it's part 
   of a connexion being recorded                                     */
/*********************************************************************/
int check(u_char *buff)
{
  u_int off;
  int i,j;
  unsigned short int len;
  struct iphdr *ip_hdr;   
  struct tcphdr *tcp_hdr; 

  ip_hdr=(struct iphdr *)(buff);
/* check your big/little endian settings */
#ifdef solaris
  len=ip_hdr->tot_len;
#else
  len=htons(ip_hdr->tot_len);
#endif

  if ( len < 40 )
    return(-1);
  if( ip_hdr->protocol!=6 )
    return(-1);

      
  tcp_hdr=(struct tcphdr *)( buff + (ip_hdr->ihl*4) );
  
  off=(ip_hdr->ihl*4)+(tcp_hdr->doff*4);
	
  if(memcmp(buff+off+4,"\xFFSMB",4)==0)
    {
      /* smb command found -> call the function to process it*/
      (*ptr[buff[off+8]])(buff+off,off);
    }
  else
    {
      if (idcnx>=0)
	{
	  if( (i=is_connexion(last_fid)) >=0 ) 
	    /* Check to see if the packet is part of a connexion we	 
	       are following */
	    {
	      j=htons(ip_hdr->tot_len)-(ip_hdr->ihl*4)-(tcp_hdr->doff*4);
		      
	      if( cnx[i].read_flag==0)
		{
		  generic_write(last_fid,j,buff+off);
		  cnx[i].read_flag=0;
		}
	      else
		{
		  generic_write(last_fid,j-4,buff+off+4);
		  cnx[i].read_flag=0;
		}
	    }
	  else
	    {
	      puts("Raw data not matching a connection");
	    }
	}
    }
  return(0);
}



/******************************************************************/
/* 
   main loop progam
   catch a packet via the pcap library 
   and send it to the check function                              
                                                                  */
/******************************************************************/
void callback(u_char *user, const struct pcap_pkthdr *h, const u_char *buff)
{
  struct iphdr *ip_hdr;   
  unsigned short int len;
  
      
  ip_hdr=(struct iphdr *)(buff+14);
      
#ifdef solaris
  len=ip_hdr->tot_len;
#else
  len=htons(ip_hdr->tot_len);
#endif
  
  if(len > 40)
    check((u_char *)(buff+14));
}

/***********************************************************************/

void sniff(pcap_t *pdes)
{
  char * buff = NULL;
    
  if( pcap_loop(pdes,-1,callback,buff) <0 )
    {
      (void)fprintf(stderr, "pcap_loop: %s\n",pcap_geterr(pdes));
      exit(1);
    }
}



/******************************************************************/
/*   test_device                                                  */
/*   initialize device and set capture filter                     */
/*   returns   0 : sucess    -1 : failure                         */
/******************************************************************/

int test_device(char *device,pcap_t **pdes)
{
  char err_buff[PCAP_ERRBUF_SIZE];
  bpf_u_int32 netp,maskp;
  struct bpf_program  bp;
  int t;


  strcpy(err_buff,"");

  
  if(strcmp(device,"")==0)  
    /* If device not specified -> autodetect */
    if ((device = pcap_lookupdev (err_buff)) == NULL)
      {
	printf ("pcap_lookupdev : %s\n", err_buff);
	return (-1);
      }
  printf("device %s detected\n",device);
  
  
   if ( (*pdes=pcap_open_live(device,SNAP_LEN,0x100,1000,err_buff)) 
       == NULL ) 
    /* obtain a packet descriptor to sniff the network */
    {
      printf("\npcap_open_live error : %s\n",err_buff);
      return(-1);
    }
  printf("listening on %s\n",device); 
  
  t=pcap_snapshot(*pdes);
  if(t!=SNAP_LEN)
    {
      printf("\npcap SNAP_LEN set to %d",t);
    }

  if ( pcap_lookupnet(device,&netp,&maskp,err_buff) == -1)
   {
     printf("\n\npcap_lookupnet error : %s",err_buff);
     return(-1);
   }

  /*
    printf("pcap_lookupnet : network number=%u  network mask=%u\n",netp,maskp);
  */
  
  
  if (pcap_compile(*pdes, &bp, FILTER, 0x100, maskp) < 0)
    /* set a filter to capture the packets that match FILTER */ 
    {
      printf("\n\n pcap_compile error : %s\n",pcap_geterr(*pdes));
      return(-1);
    }
  
 if (pcap_setfilter(*pdes, &bp) < 0)
   {
     printf("\n\n pcap_setfilter error : %s\n",pcap_geterr(*pdes));
     return(-1);
   }
 
 printf("pcap_setfilter OK\n\n");
 
 return(0);
}

/*************************************************************************/
/* 
   Read a tcpdump file and pass a packet to the check function
*/
/*************************************************************************/

int read_tcpdumplog(char *fname)
{
 pcap_t *tpcap;
 bpf_u_int32 maskp;
 char err_buff[1024],msg[2048];
 struct bpf_program	bp; 


if ( (tpcap=pcap_open_offline(fname,err_buff))!=NULL )
  {
    puts("pcap_open OK");

    if (pcap_compile(tpcap, &bp, FILTER, 0x100, maskp) < 0)
      /* set a filter to capture the packets that match FILTER */ 
      {
	printf("\n\n pcap_compile error : %s\n",pcap_geterr(tpcap));
	return(1);
      }
    if (pcap_setfilter(tpcap, &bp) < 0)
      {
	printf("\n\n pcap_setfilter error : %s\n",pcap_geterr(tpcap));
	return(1);
      }    
    printf("pcap_setfilter OK\n\n");    
    sniff(tpcap);
  }
 else
   {
     snprintf(msg,255,"pcap_open error : %s",err_buff);
     msg[255]='\0';
     puts(msg);
     return(1);     
   } 

return(0);

}


/*************************************************************************/

void it()
{
  system("echo");
  system("echo 'process terminated on SIGINT'");
  exit(0);
}

/*************************************************************************/

int main(int argc, char **argv)
{
  register int op;
  char device[512],filename[255],rflag=0;
  pcap_t *pdes;
  
  init_ptr();
  idcnx=-1;
  ok=0;
  ignore=0;

  signal(SIGINT,&it);
  strcpy(device,"");
  
  while (
	 (op = getopt(argc, argv, "fdh")) != EOF)
    switch (op) 
      {
      case 'd':
	if(argc >= 2)
	  {
	    strncpy(device,argv[2],10);
	    device[10]='\0';
	  }
	else
	  {
	   fprintf(stderr,"\Error : No device specified\n"); 
	   return(1);
	  }
	break;

	   case 'h':
	fprintf(stderr,"\nUsage : %s <-d device> <-f file-name>\n",argv[0]);
	fprintf(stderr,"default is autodetection\n\n");
	return(1);

      case 'f':
	if(argc >= 2)
	  {
	    rflag++;
	    strncpy(filename,argv[2],100);
	    device[100]='\0';
	    fprintf(stderr,"opening file %s\n\n",filename);
	  }
	else
	  {
	   fprintf(stderr,"\Error : No input file specified\n"); 
	   return(1);
	  }
	break;
      }

if(rflag==0)
  {
    if( test_device(device,&pdes)  == 0 )
      {
	if(pdes!=NULL) 
	  sniff(pdes);
      }
  }
if(rflag==1)
 read_tcpdumplog(filename);

return(0);
}
