dnl -*- sh -*-
dnl Copyright (c) 2001 Thomas Schultz <tststs@gmx.de>
dnl partly based on code by N. D. Bellamy

dnl Wrapper around AC_ARG_ENABLE to set compile time options.
dnl
dnl Parameters:
dnl $1 = option name
dnl $2 = help string
dnl $3 = variable to set in sysconf.h

AC_DEFUN([CF_COMPILE_OPTION],
[AC_ARG_ENABLE($1,[$2],[if test "$enableval" != "no" ; then
AC_DEFINE($3, 1)
else
AC_DEFINE($3, 0)
fi])])dnl

AC_DEFUN(CF_PATH_SLANG_LIB,
[
  AC_MSG_CHECKING(for the slang library)
  
  ac_slang_library="no"
  
  AC_ARG_WITH(slang-library,
    [  --with-slang-library    Where the slang library is located ],
    [  ac_slang_library="$withval" ])

  AC_CACHE_VAL(ac_cv_lib_slang, [
    
    dnl Did the user give --with-slang-libraries?
    
    if test "$ac_slang_library" = no; then

      dnl No they didn't, so lets look for them...
    
      dnl If you need to add extra directories to check, add them here.
      
      slang_library_dirs="\
        /usr/local/lib/slang \
	/usr/local/lib \
	/usr/lib/slang \
        /usr/lib \
	/usr/pkg/lib"
  
      for slang_dir in $slang_library_dirs; do
        if test -r $slang_dir/libslang.a || test -r $slang_dir/libslang.so; then
          ac_slang_library=$slang_dir
          break
        fi
      done
    fi

    ac_cv_lib_slang=$ac_slang_library
  ])

  AC_MSG_RESULT([$ac_cv_lib_slang])

  if test "$ac_cv_lib_slang" = no; then
    AC_MSG_ERROR([

I can't find the slang library.

Install the slang library, or if you have it installed, override this check
with the --with-slang-library=DIR option, and I'll take your word for it.
])

  fi
  
  SLANG_LIB_DIR="$ac_cv_lib_slang"
  SLANG_LIB="-L$ac_cv_lib_slang"
  
# gcc under solaris is often not installed correctly.  Avoid specifying
# -L/usr/lib.
if test "SLANG_LIB" = "-L/usr/lib"
then
    SLANG_LIB=""
fi

AC_SUBST(SLANG_LIB)dnl
AC_SUBST(SLANG_LIB_DIR)dnl
])

AC_DEFUN(CF_PATH_SLANG_INC,
[
  AC_MSG_CHECKING(for the slang includes)
  
  ac_slang_includes="no"
  
  AC_ARG_WITH(slang-includes,
    [  --with-slang-includes   Where the slang headers are located ],
    [  ac_slang_includes="$withval" ])
  
  AC_CACHE_VAL(ac_cv_header_slanginc, [
    
    dnl Did the user give --with-slang-includes?
    
    if test "$ac_slang_includes" = no; then

      dnl No they didn't, so lets look for them...

      dnl If you need to add extra directories to check, add them here.
      
      slang_include_dirs="\
        /usr/local/include/slang \
	/usr/local/include \
	/usr/include/slang \
        /usr/include \
	/usr/pkg/include"
      
      for slang_dir in $slang_include_dirs; do
        if test -r "$slang_dir/slang.h"; then
          ac_slang_includes=$slang_dir
          break
        fi
      done
    fi

    ac_cv_header_slanginc=$ac_slang_includes
  
  ])

  if test "$ac_cv_header_slanginc" = no; then
    AC_MSG_ERROR([

I can't find the slang header files.

Install the slang development package, or if you have it installed, override
this check with the --with-slang-includes=DIR option, and I'll take your
word for it.
])

  fi

  AC_MSG_RESULT([$ac_cv_header_slanginc])
  SLANG_INCLUDE="$ac_cv_header_slanginc"
  SLANG_INC="-I$ac_cv_header_slanginc"
  
# gcc under solaris is often not installed correctly.  Avoid specifying
# -I/usr/include.
if test "SLANG_INC" = "-I/usr/include"
then
    SLANG_INC=""
fi

AC_SUBST(SLANG_INC)dnl
AC_SUBST(SLANG_INCLUDE)dnl
])

AC_DEFUN(CF_VA_COPY,
[
 dnl va_copy checks taken from glib 1.2.8
 dnl
 dnl we currently check for all three va_copy possibilities, so we get
 dnl all results in config.log for bug reports.
AC_MSG_CHECKING(for an implementation of va_copy())
AC_CACHE_VAL(slrn_cv_va_copy,[
	AC_TRY_RUN([
	#include <stdarg.h>
	void f (int i, ...) {
	va_list args1, args2;
	va_start (args1, i);
	va_copy (args2, args1);
	if (va_arg (args2, int) != 42 || va_arg (args1, int) != 42)
	  exit (1);
	va_end (args1); va_end (args2);
	}
	int main() {
	  f (0, 42);
	  return 0;
	}],
	slrn_cv_va_copy=yes
	,
	slrn_cv_va_copy=no
	,)
])
AC_MSG_RESULT($slrn_cv_va_copy)
AC_MSG_CHECKING(for an implementation of __va_copy())
AC_CACHE_VAL(slrn_cv___va_copy,[
	AC_TRY_RUN([
	#include <stdarg.h>
	void f (int i, ...) {
	va_list args1, args2;
	va_start (args1, i);
	__va_copy (args2, args1);
	if (va_arg (args2, int) != 42 || va_arg (args1, int) != 42)
	  exit (1);
	va_end (args1); va_end (args2);
	}
	int main() {
	  f (0, 42);
	  return 0;
	}],
	slrn_cv___va_copy=yes
	,
	slrn_cv___va_copy=no
	,)
])
AC_MSG_RESULT($slrn_cv___va_copy)
AC_MSG_CHECKING(whether va_lists can be copied by value)
AC_CACHE_VAL(slrn_cv_va_val_copy,[
	AC_TRY_RUN([
	#include <stdarg.h>
	void f (int i, ...) {
	va_list args1, args2;
	va_start (args1, i);
	args2 = args1;
	if (va_arg (args2, int) != 42 || va_arg (args1, int) != 42)
	  exit (1);
	va_end (args1); va_end (args2);
	}
	int main() {
	  f (0, 42);
	  return 0;
	}],
	slrn_cv_va_val_copy=yes
	,
	slrn_cv_va_val_copy=no
	,)
])
if test "x$slrn_cv_va_copy" = "xyes"; then
  AC_DEFINE(VA_COPY, va_copy)
else if test "x$slrn_cv___va_copy" = "xyes"; then
  AC_DEFINE(VA_COPY, __va_copy)
fi
fi
if test "x$slrn_cv_va_val_copy" = "xno"; then
  AC_DEFINE(VA_COPY_AS_ARRAY)
fi
AC_MSG_RESULT($slrn_cv_va_val_copy)
])
