.\"
.\" Man page for just the sliderule part of the old X11R3 xcalc(1)
.\" utility.
.\"
.\" Man page written by Joerg Wunsch <joerg_wunsch@uriah.heep.sax.de>,
.\" and put into the public domain.  Based on the old xcalc.1, although
.\" the old man page didn't describe the slide rule function at all.
.\"
.\" (Emacs enjoys this one =>)"
.TH SLIDERULE 1 "3 August 1997" "X Version 11"
.SH NAME
sliderule \- calculator featuring a historic slide rule
.SH SYNOPSIS
.B sliderule
[-display \fIdisplay\fP]  [-bw \fIpixels\fP] [-stip] [-rv]
[-geometry \fIgeometry\fP]
.SH DESCRIPTION
.I Sliderule
features a historic slide rule calculator.  You can multiply, divide,
calculate reciprocals, squares, square roots, and even trignometrical
functions.  Anyway, you need to know how to do this.  You can't add or
subtract \- but if you know a sliderule, you knew this already.  If
you don't know, don't worry: this man page won't make you learning it
either.
.SH OPTIONS
.PP
.TP 8
.B \-display \fIdisplayname\fP
This option specifies the X server to contact.
.PP
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the size and placement of the top level window.  By 
default, the minimum size will be used.  Doesn't work very well at all.
.PP
.TP 8
.B \-fg \fIcolor\fP
This option specifies the foreground color to use.
.PP
.TP 8
.B \-bg \fIcolor\fP
This option specifies the background color to use.
.PP
.TP 8
.B \-bw \fIpixels\fP
This option specifies the border width in pixels.
.PP
.TP 8
.B \-stip
This option indicates that the background of the calculator should be 
drawn using a stipple of the foreground and background colors.  On monochrome
displays this makes for a nicer display.
.PP
.TP 8
.B \-rv
This option indicates that reverse video should be used.
.PP
.SH OPERATION
.PP
The slide rule is operated with the pointer.  The only keyboard input
that has any effect at all is the key "q" to quit the program.
.PP
The slide rule consists mainly of three different areas: the outside
scales that are normally fixed with the left hand, and the slider that
is moved with the right hand.  When moving the slider, a black
background will become visible.
.PP
Pressing button 1 inside the outer part of the slide rule will move
the hairline to the pointer position, and update the digital display at
the left-hand side (some comfort a real slide-rule wasn't fond of).
Moving the pointer around while keeping button 1 pressed, will drag
the hairline.
.PP
Pressing button 2 or 3 in the outer part, will double or half the
width of the slide rule, respectively.  This doesn't work very well.
.PP
Pressing button 1 on the slider, or in the black area exposed by the
moved away slider, will move the slider so that the pointer position
will become the "1" on the slider.  Moving the pointer then, while
keeping the button pressed, will drag the slider accordingly.
.PP
Pressing button 3 on the slider, or in the black area, will behave
similarly, using the "10" position of the slider.
.PP
Pressing button 2 on the slider allows you to grab and drag the slider
without moving it first.
.PP
For the curious, the various scales are:
.PP
.RS
\fBL\fP	mantissa of the decimal logarithm of \fBD\fP
.br
\fBA\fP	square of \fBD\fP
.br
\fBB\fP	square of \fBC\fP
.br
\fBCI\fP	reciprocal of \fBC\fP
.br
\fBC\fP	base scale
.br
\fBD\fP	base scale
.br
\fBDI\fP	reciprocal of \fBD\fP
.br
\fBS\fP	arc sine of \fBD\fP
.br
\fBT\fP	arc tangent of \fBD\fP
.RE
.SH "SEE ALSO"
xcalc(1)
.SH BUGS
.PP
Resizing of either way doesn't work pretty well.  Best leave the
geometry as it is.
.PP
Sliderule uses a prehistoric way to obtain X resources, which is not
documented in this man page.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
John Bradley, University of Pennsylvania
.br
Mark Rosenstein, MIT Project Athena
.SH HISTORY
Sliderule used to be the option "-analog" of the old xcalc application,
up to X11R3.  This option has been dropped later, when the stock X11
xcalc was rewritten as a Toolkit application.  This
.B sliderule
application is just the old "-analog" code only, with some bugs and
inaccuracies fixed, and the trigonometrical scales added.  This work
was done by
.ie t J\(:org Wunsch.
.el Joerg Wunsch.
