/*
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003 Brian Carrier.  All rights reserved
 *
 * get - guesses which endian ordering to use
 *
 * mmtools is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * mmtools is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mactime; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, LOSS OF USE, DATA, OR PROFITS OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "mm_tools.h"
#include "error.h"

/*
 * The getuX functions are now defined as macros in mm_tools.h
 */

/*
 * try both endian orderings to figure out which one is equal to 'val'
 *
 * if neither of them do, then 1 is returned.  Else 0 is.
 * mm->flags will be set accordingly
 */
u_int8_t
guessu16(MM_INFO *mm, u_int8_t *x, u_int16_t val)
{
	/* try little */
	mm->flags &= ~MM_BIG_ENDIAN;
	mm->flags |= MM_LIT_ENDIAN;
	if (getu16(mm, x) == val)
		return 0;

	/* ok, big now */
	mm->flags &= ~MM_LIT_ENDIAN;
	mm->flags |= MM_BIG_ENDIAN;
	if (getu16(mm, x) == val)
		return 0;

	/* didn't find it */
	return 1;
}

/*
 * same idea as guessu16 except that val is a 32-bit value
 *
 * return 1 on error and 0 else
 */
u_int8_t
guessu32(MM_INFO *mm, u_int8_t *x, u_int32_t val)
{
	/* try little */
	mm->flags &= ~MM_BIG_ENDIAN;
	mm->flags |= MM_LIT_ENDIAN;
	if (getu32(mm, x) == val)
		return 0;

	/* ok, big now */
	mm->flags &= ~MM_LIT_ENDIAN;
	mm->flags |= MM_BIG_ENDIAN;
	if (getu32(mm, x) == val)
		return 0;

	return 1;
}

