/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class DiffMergePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text mergeProgramLocationText;
    private Text mergeProgramParametersText;
    private Button mergeProgramParametersButton;
    private Button builtInMergeRadioButton;
    private Button externalMergeRadioButton;
    private Button browseMergeProgramButton;

    private Label createLabel(Composite parent, String text, int span, int horizontalIndent) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.horizontalIndent = horizontalIndent;
        label.setLayoutData((Object)data);
        return label;
    }

    private Text createCopiableLabel(Composite parent, String text, int span, int horizontalIndent) {
        Text textControl = new Text(parent, 8);
        textControl.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        data.horizontalIndent = horizontalIndent;
        textControl.setLayoutData((Object)data);
        return textControl;
    }

    private Button createRadio(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    private Text createText(Composite parent, int widthHint) {
        Text textControl = new Text(parent, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = widthHint;
        gridData.grabExcessHorizontalSpace = true;
        textControl.setLayoutData((Object)gridData);
        return textControl;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        Group group = new Group(composite, 0);
        group.setText(Policy.bind("DiffMergePreferencePage.mergeProgramGroup"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Listener updateEnablementsListener = new Listener(){

            public void handleEvent(Event event) {
                DiffMergePreferencePage.this.updateEnablements();
            }
        };
        this.builtInMergeRadioButton = this.createRadio((Composite)group, Policy.bind("DiffMergePreferencePage.builtInMerge"), 3);
        this.builtInMergeRadioButton.addListener(13, updateEnablementsListener);
        this.externalMergeRadioButton = this.createRadio((Composite)group, Policy.bind("DiffMergePreferencePage.externalMerge"), 1);
        this.externalMergeRadioButton.addListener(13, updateEnablementsListener);
        this.mergeProgramLocationText = this.createText((Composite)group, 200);
        this.mergeProgramLocationText.setEditable(false);
        this.browseMergeProgramButton = new Button((Composite)group, 0);
        this.browseMergeProgramButton.setText(Policy.bind("DiffMergePreferencePage.browse"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.browseMergeProgramButton.setLayoutData((Object)gridData);
        this.browseMergeProgramButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(DiffMergePreferencePage.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    DiffMergePreferencePage.this.mergeProgramLocationText.setText(res);
                }
            }
        });
        this.createLabel((Composite)group, Policy.bind("DiffMergePreferencePage.mergeProgramParameters"), 1, 20);
        Control[] formatEditorControl = this.createFormatEditorControl((Composite)group, Policy.bind("DiffMergePreferencePage.mergeProgramVariables"), this.getMergeBindingDescriptions());
        this.mergeProgramParametersText = (Text)formatEditorControl[0];
        this.mergeProgramParametersButton = (Button)formatEditorControl[1];
        this.createLabel((Composite)group, Policy.bind("DiffMergePreferencePage.tortoiseMergeComment1"), 3, 20);
        this.createCopiableLabel((Composite)group, Policy.bind("DiffMergePreferencePage.tortoiseMergeComment2"), 3, 20);
        this.initializeValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.tigris.subversion.subclipse.ui.diff_merge_preferences_page_context");
        return composite;
    }

    protected Control[] createFormatEditorControl(Composite composite, String buttonText, final Map supportedBindings) {
        Text format = new Text(composite, 2048);
        format.setLayoutData((Object)new GridData(768));
        Button b = new Button(composite, 0);
        b.setText(buttonText);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        b.setLayoutData((Object)data);
        final Text formatToInsert = format;
        b.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DiffMergePreferencePage.this.addVariables(formatToInsert, supportedBindings);
            }
        });
        return new Control[]{format, b};
    }

    private void addVariables(Text target, Map bindings) {
        final ArrayList<StringPair> variables = new ArrayList<StringPair>(bindings.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((StringPair)element).s1) + " - " + ((StringPair)element).s2;
            }
        };
        IStructuredContentProvider contentsProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return variables.toArray(new StringPair[variables.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        Iterator it = bindings.keySet().iterator();
        while (it.hasNext()) {
            StringPair variable = new StringPair();
            variable.s1 = (String)it.next();
            variable.s2 = (String)bindings.get(variable.s1);
            variables.add(variable);
        }
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setContentProvider(contentsProvider);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setInput(variables);
        dialog.setTitle(Policy.bind("DiffMergePreferencePage.addVariableDialogTitle"));
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        int i = 0;
        while (i < result.length) {
            target.insert("${" + ((StringPair)result[i]).s1 + "}");
            ++i;
        }
    }

    private Map getMergeBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("merged", Policy.bind("DiffMergePreferencePage.mergedVariableComment"));
        bindings.put("theirs", Policy.bind("DiffMergePreferencePage.theirsVariableComment"));
        bindings.put("yours", Policy.bind("DiffMergePreferencePage.yoursVariableComment"));
        bindings.put("base", Policy.bind("DiffMergePreferencePage.baseVariableComment"));
        return bindings;
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.mergeProgramLocationText.setText(store.getString("pref_merge_program_location"));
        this.mergeProgramParametersText.setText(store.getString("pref_merge_program_parameters"));
        if (store.getBoolean("pref_merge_use_external")) {
            this.builtInMergeRadioButton.setSelection(false);
            this.externalMergeRadioButton.setSelection(true);
        } else {
            this.builtInMergeRadioButton.setSelection(true);
            this.externalMergeRadioButton.setSelection(false);
        }
        this.updateEnablements();
    }

    private void updateEnablements() {
        if (this.builtInMergeRadioButton.getSelection()) {
            this.browseMergeProgramButton.setEnabled(false);
            this.mergeProgramParametersText.setEnabled(false);
            this.mergeProgramParametersButton.setEnabled(false);
            this.mergeProgramLocationText.setEnabled(false);
        } else {
            this.browseMergeProgramButton.setEnabled(true);
            this.mergeProgramParametersText.setEnabled(true);
            this.mergeProgramParametersButton.setEnabled(true);
            this.mergeProgramLocationText.setEnabled(true);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeValues();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("pref_merge_program_location", this.mergeProgramLocationText.getText());
        store.setValue("pref_merge_program_parameters", this.mergeProgramParametersText.getText());
        store.setValue("pref_merge_use_external", this.externalMergeRadioButton.getSelection());
        return true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SVNUIPlugin.getPlugin().getPreferenceStore();
    }

    class StringPair {
        String s1;
        String s2;

        StringPair() {
        }
    }
}

