/*
 * SiSCtrl - SiS Display Control Panel
 * for the SiS X.org/XFree86 driver
 *
 * Shared definitions (MAIN and GUI)
 *
 * (C) 2003-2005 Thomas Winischhofer <thomas@winischhofer.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SISC_H_
#define _SISC_H_

#include <config.h>

#define SISVERSION PACKAGE_VERSION

#if defined(HAVE_SYS_SHM_H) && defined(HAVE_XV)
#define USEXV
#endif

#if 1
#define USE_DEPRECATED_XV	/* Use Xv interface if SiSCtrl extension is not found */
#endif

#if 1
#define USE_STRAY		/* Include code for system tray icon */
#endif

/* I don't check for HAVE_'s here, because the program
 * won't compile anyway if any of the headers is missing
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <fcntl.h>
#ifdef HAVE_MATH_H
#include <math.h>
#endif
#include <sys/stat.h>
#include <sys/time.h>
#include <time.h>
#include <X11/Xatom.h>
#include <X11/extensions/xf86vmode.h>
#include <X11/extensions/xf86vmstr.h>
#ifdef USEXV
#include <X11/extensions/XShm.h>   /* Include BEFORE Xvlib.h! */
#endif
#include <X11/extensions/Xvlib.h>
#ifdef USEXV
#include <sys/shm.h>
#endif

#ifdef HAVE_RANDR
#include <X11/Xproto.h>
#include <X11/extensions/Xrandr.h>
#include <X11/extensions/Xrender.h>
#endif

#ifdef HAVE_XINERAMA
#include <X11/extensions/Xinerama.h>
#include <X11/extensions/panoramiXproto.h>
#endif

#include "sisctrlstr.h"

/* Maximum amount of modes this tool
 * can handle in the display mode tab
 */
#define SISCTRL_MAXMODES 85

/*************************************
 *      GUI interface definitions    *
 *************************************/

typedef struct {

	Display *dpy;			/* Display */

	char *	windowtitle;		/* SiSCtrl window title */

	int	xineramaeb;		/* Xinerama event base */

	int	do_randr;		/* Include RandR widgets and signals */
	int	numrandrsizes;		/* Number of RandR sizes */
	Rotation supportedrots;		/* Supported rotations */

	int	screennum;		/* (Xinerama:) Screen number */

	/* Xv extension */
	int	xv_port_nr;		/* XV port number (for Xv demo ONLY!!!) */
	unsigned int xv_req_base, xv_event_base, xv_error_base;

	int	havevb;
	int	mergedfb;
	int	dualhead;

	int	islaptop;		/* Is laptop (dvi-d <> lcd graphics) */

	/* Displaymode page */

	char *	modetextptr[SISCTRL_MAXMODES];
	char *  leaveunchanged_text;	/* Text for "Leave unchanged at xxx" menu item */
	char *	keeprot_text;
	char *	sizetextptr[SISCTRL_MAXMODES+2];
	int	startmodeindex;		/* Initial to-be-selected index in display mode list */

	int	do_mergedfb_details;	/* Include MergedFB mode "Metamode details */
	int	do_mergedfb_gfx;
	int	globalmfbpos;

	/* CRT1 and CRT2 pages */

	int	supportlcda;		/* HW supports LCD via CRT1 */
	int	supportdvi;		/* LCD is DVI/TMDS or LVDS */
	int	supportscale;		/* LCD scaling supported */
	int	supportcenter;		/* LCD centering/pass1:1 supported */

	int	supportpalmn;		/* PAL-M/PAL-N supported */
	int	supportntscj;		/* NTSCJ supported */
	int	supportypbpr;		/* YpbPr supported */
	int	supportypbpr625i;	/* YpbPr 625i supported */
	int	supportypbpr625p;	/* YpbPr 625p supported */
	int	supporthivision;	/* HiVision supported */
	int	supportoverscan;	/* Overscan supported (chrontel) */
	int	supportsoverscan;	/* Super-overscal supported */
	int	supportypbprar;		/* Support YPbPbr aspect ratio */

	int 	supportvga2;		/* Support secondary VGA */

	int	supportcrt1redetect;	/* CRT1 device redetection supported */
	int	supportcrt2redetect;	/* CRT2 device redetection supported */

	/* tv page */

	int	supporttvsaturation;	/* support TV features */
	int	supporttvedgeenhance;
	int	supporttvpos;
	int	supporttvsize;

	/* gamma page */

	int	gammaenablecrt1;	/* Make "Enable for CRT1" sensible */
	int	gammaenablecrt2;	/* Make "Enable for CRT2" sensible */
	int	havesepgamma2;		/* Support separate gamma for CRT1 and CRT2 */
	int     usenewgamma;		/* New gamma brightness/contrast */

	int	supportsatcrt1;		/* Supports CRTx saturation */
	int	supportsatcrt2;

	unsigned short *ramp[3];	/* Pointers to gamma ramp */
	int 	nramp;			/* Number of elements for each color channel */

	float   crt1mongamma, crt2mongamma;

	/* video page */

	int	supportxvgamma1;	/* Supports xv gamma */
	int	supporthuesat;		/* Supports hue and saturation */
	int	needswitchcrt;		/* Include switch crt widgets */
	int	noxvdemo;		/* Do not display Xv image in Video tab */

	/* page types */

	int	crt1_page_type;
	int	crt2_page_type;
	int	gamma_page_type;
	int	tv_page_type, tv_page_subtype;
	int	video_page_type, video_page_subtype;
	int	config_page_type;

	int 	iconify;		/* Start sisctrl iconified */
#ifdef USE_STRAY
	int	dontusesystemtray;	/* Use/don't setup system tray icon */
	char *	straytooltip;		/* SiSCtrl system tray tooltip */
#endif
} gui_look;


/* In the following, the "menu indices" are as the
 * main program understands them. The GUI part must
 * eventually translate them.
 * For out GTK implementation, they match the real
 * menu indices (hence no translation is required).
 *
 */

#define SIS_PAGE_DM	0
#define SIS_PAGE_CRT1	1
#define SIS_PAGE_CRT2	2
#define SIS_PAGE_TV	3
#define SIS_PAGE_COLOR	4
#define SIS_PAGE_VIDEO	5
#define SIS_PAGE_CONFIG	6
#define SIS_PAGE_ABOUT	7

/*        Display mode page          */

/* Bitfield for device support */
#define SiS_CRT2_LCD	    0x0001
#define SiS_CRT2_TV	    0x0002
#define SiS_CRT2_TVPAL	    0x0004
#define SiS_CRT2_TVNTSC	    0x0008
#define SiS_CRT2_TVPALM	    0x0010
#define SiS_CRT2_TVPALN	    0x0020
#define SiS_CRT2_CRT1LCDA   0x0040
#define SiS_CRT2_HIVISION   0x0080
#define SiS_CRT2_YPBPR525I  0x0100
#define SiS_CRT2_YPBPR525P  0x0200
#define SiS_CRT2_YPBPR750P  0x0400
#define SiS_CRT2_YPBPR1080I 0x0800
#define SiS_CRT2_VGA2       0x1000
#define SiS_CRT2_YPBPR625I  0x2000
#define SiS_CRT2_YPBPR625P  0x4000

#define DM_GI_CRT		0
#define DM_GI_LCD		1
#define DM_GI_TV		2
#define DM_GI_NUM		DM_GI_TV + 1

#define SIS_MFB_HORIZ		0	/* global mergedfb placement relation */
#define SIS_MFB_VERT		1


/*             CRT1 page             */

/* Page layout types */
#define CRT1_PAGE_TYPE_NORMAL	0
#define CRT1_PAGE_TYPE_REDETECT_ONLY 1
#define CRT1_PAGE_TYPE_NA_NOVB	2
#define CRT1_PAGE_TYPE_NA_DHM	3

/* Menu index for CRT1 menu */
#define C1_MI_VGA	0
#define C1_MI_LCDA	1
#define C1_MI_OFF	2
#define C1_MI_MAX	C1_MI_OFF
#define C1_MI_NUM	(C1_MI_MAX + 1)

/* graphics number */
#define C1_GFX_OFF	0
#define C1_GFX_VGA	1
#define C1_GFX_LCDA	2

/*             CRT2 page             */

#define CRT2_PAGE_TYPE_NORMAL	0
#define CRT2_PAGE_TYPE_NA_NOVB	1
#define CRT2_PAGE_TYPE_NA_DHM	2

/* Menu index for CRT2 menu */
#define C2_MI_TV_LCD	0
#define C2_MI_TV_SVHS	1
#define C2_MI_TV_CVBS	2
#define C2_MI_TV_CVSV	3
#define C2_MI_TV_TV	4
#define C2_MI_TV_HIVI	5
#define C2_MI_TV_YPBPR	6
#define C2_MI_TV_VGA	7
#define C2_MI_TV_SCART	8
#define C2_MI_TV_OFF	9
#define C2_MI_MAX	C2_MI_TV_OFF
#define C2_MI_NUM	(C2_MI_MAX + 1)

/* graphics number */
#define C2_GFX_TV_LCD	0
#define C2_GFX_TV_SVHS	1
#define C2_GFX_TV_CVBS	2
#define C2_GFX_TV_CVSV	3
#define C2_GFX_TV_TV	4
#define C2_GFX_TV_HDTV	5
#define C2_GFX_TV_VGA	6
#define C2_GFX_NONE	7

/* Menu indices on LCD scaling menu */
#define CO_MI_SC_DEFAULT	0
#define CO_MI_SC_ON		1
#define CO_MI_SC_OFF		2

/* Menu indices on LCD centering menu */
#define CO_MI_CE_DEFAULT	0
#define CO_MI_CE_CENTEROFF	1
#define CO_MI_CE_CENTER		2

/* Menu indices on signal type menu */
#define C2_MI_ST_525I		0
#define C2_MI_ST_525P		1
#define C2_MI_ST_625I		2
#define C2_MI_ST_625P		3
#define C2_MI_ST_750P		4
#define C2_MI_ST_1080I		5
#define C2_MI_ST_NUM		(C2_MI_ST_1080I + 1)

/* Menu indices on aspect ratio menu */
#define C2_MI_AS_43		0
#define C2_MI_AS_43LB		1
#define C2_MI_AS_169		2

/* Menu indices in TV standard menu */
#define C2_MI_TV_PAL		0
#define C2_MI_TV_NTSC		1
#define C2_MI_TV_PALM		2
#define C2_MI_TV_PALN		3
#define C2_MI_TV_NTSCJ		4
#define C2_MI_TV_NUM		(C2_MI_TV_NTSCJ + 1)

/* Menu indices in chrontel overscan menu */
#define C2_MI_OV_BIOS		0
#define C2_MI_OV_UNDERSCAN	1
#define C2_MI_OV_OVERSCAN	2
#define C2_MI_OV_SUPEROVERSCAN	3

/*               TV page              */

#define TV_PAGE_TYPE_NORMAL	0
#define TV_PAGE_TYPE_NA_NOTV	1

#define TV_PAGE_SUBTYPE_SIS		0
#define TV_PAGE_SUBTYPE_CHRONTEL	1
#define TV_PAGE_SUBTYPE_UNDEFINED	2

/* Menu indices for TV/Antiflicker menu */
#define TV_AF_OFF		0
#define TV_AF_LOW		1
#define TV_AF_MEDIUM		2
#define TV_AF_HIGH		3
#define TV_AF_ADAPTIVE		4

/* slider numbers for chrontel page type */
#define TV_CH_SLI_CONTRAST	0
#define TV_CH_SLI_TEXTENHANCE	1
#define TV_CH_SLI_CHROMAFF	2
#define TV_CH_SLI_LUMAFF	3

/*             Gamma page             */

#define GAMMA_PAGE_TYPE_XINERAMA	0
#define GAMMA_PAGE_TYPE_NORMAL		1

#define GAMMA_GFX_CRT1		0
#define GAMMA_GFX_CRT2		1
#define GAMMA_GFX_BOX22		2
#define GAMMA_GFX_BOX18		3
#define GAMMA_GFX_BOXCU		4
#define GAMMA_GFX_BAR22		5
#define GAMMA_GFX_BAR18		6
#define GAMMA_GFX_BARCU		7
#define GAMMA_GFX_BRI		8
#define GAMMA_GFX_RGB		9
#define GAMMA_GFX_GREY		10
#define GAMMA_GFX_CMY		11
#define GAMMA_GFX_DARK		12
#define GAMMA_GFX_MEDIUM	13
#define GAMMA_GFX_LIGHT		14
#define GAMMA_GFX_NUM		(GAMMA_GFX_LIGHT + 1)

/*              Video page              */

#define VIDEO_PAGE_TYPE_NORMAL		0
#define VIDEO_PAGE_TYPE_NA_NOOVL	1

#define VIDEO_PAGE_SUBTYPE_NORMAL	0
#define VIDEO_PAGE_SUBTYPE_WITH_GLOBAL	1
#define VIDEO_PAGE_SUBTYPE_UNDEFINED	2

/* slider numbers  */
#define VI_SLI_CONTRAST		0
#define VI_SLI_BRIGHTNESS	1
#define VI_SLI_HUE		2
#define VI_SLI_SATURATION	3

/*             Current page             */

#define CONFIG_PAGE_TYPE_HINTS		0
#define CONFIG_PAGE_TYPE_NO_HINTS	1

#define CF_HINTS_NO		0
#define CF_HINTS_GE		1
#define CF_HINTS_MFB		2
#define CF_HINTS_DHM		3

#define CU_TT_GREY		0
#define CU_TT_BLACK		1
#define CU_TT_BLACK_BOLD	2
#define CU_TT_RED		3
#define CU_TT_RED_BOLD		4
#define CU_TT_BLUE		5
#define CU_TT_BLUE_BOLD		6

/*               Info page              */
#define AB_TT_BLACK		0
#define AB_TT_BLACK_BOLD	1


#endif
