########################################################################
# Hopefully, you will not need to modify below here.
########################################################################

LIBRARY = ../../lib/libshunt.a

CC = gcc

ifdef DEBUG
    DCFLAGS += -g
else
    DCFLAGS += -O2 -DNDEBUG
endif

ifdef PROFILE
    PROFILE_FLAGS = -pg -fprofile-arcs
endif

CPPFLAGS += -MMD
CFLAGS = $(DCFLAGS) -Wall $(PROFILE_FLAGS)

#STATIC += -static
LDFLAGS += $(STATIC) $(PROFILE_FLAGS)

DEPS = $(LOCAL_OBJS:%.o=.%.d) $(LIBRARY_OBJS:%.o=.%.d)

PROFILE_DATA = $(LOCAL_OBJS:%.o=%.da) $(LIBRARY_OBJS:%.o=%.da)

# Cygwin adds .exe as the extension.
UNAME := $(shell uname)
ifeq (CYGWIN,$(findstring CYGWIN,$(UNAME)))
    ifneq ($(PROG),)
        EXE = .exe
    else
        EXE =
    endif
endif


# We need to alter the compile rule in order to post-process
# the automatically generated dependencies file.
%.o: %.c
	$(CC) $(CFLAGS) $(CPPFLAGS) $(INCL) -o $@ -c $<
	@for local in main.o $(LOCAL_OBJS) ; do \
             if [ "$@" = "$$local" ] ; then \
                 mv $*.d .$*.d ; \
                 exit 0; \
             fi ;\
         done ;\
         sed -e 's|^$@:|$(LIBRARY)($@):|' $*.d > .$*.d && rm $*.d

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) $(INCL) -o $@ -c $<
	@for local in main.o $(LOCAL_OBJS) ; do \
             if [ "$@" = "$$local" ] ; then \
                 mv $*.d .$*.d ; \
                 exit 0; \
             fi ;\
         done ;\
         sed -e 's|^$@:|$(LIBRARY)($@):|' $*.d > .$*.d && rm $*.d

# We do not need the .o files to stay on the system.
ARFLAGS = cru
$(LIBRARY)(%.o): %.o
	$(AR) $(ARFLAGS) $(LIBRARY) $<
	@$(RM) $<

all: $(PROG)$(EXE) $(LOCAL_OBJS) $(LIBRARY)($(LIBRARY_OBJS))
	@echo "Done."

$(PROG)$(EXE): main.o $(LOCAL_OBJS) $(LIBRARY)
	$(CC) $(LDFLAGS) -o $@ $< $(LOCAL_OBJS) $(LIBRARY) $(LDLIBS)

clean:
	-$(RM) $(PROFILE_DATA)
	-$(RM) main.o .main.d $(LOCAL_OBJS) $(DEPS)
	-@if [ -r $(LIBRARY) ] ; then $(AR) d $(LIBRARY) $(LIBRARY_OBJS) ; fi

clobber: clean
	-$(RM) $(PROG)$(EXE) $(LIBRARY)

-include .main.d $(DEPS)

.PHONY: all clean clobber
