#! /bin/sh

# $Id: test-general.sh,v 1.6 2002/01/29 20:14:54 jason Exp $

SHORTEN=../src/shorten

if [ ! -x "$SHORTEN" ]; then
  echo "*** $SHORTEN is missing, please build it ***"
  exit 1
fi

echo ""
echo "========================  General shorten tests  ========================="
echo ""

for testdir in mono stereo; do

  echo "+ Running general shorten tests against $testdir benchmark files..."
  echo ""

  for testfile in test.shn test.skt test.wav seekable.shn; do
    if [ ! -f "$testdir/$testfile" ]; then
      echo "*** Missing test file '$testfile', cannot continue... ***"
      exit 1
    fi
  done

  # sanity checks
  $SHORTEN -x $testdir/test.shn tmp.wav || exit 1
  cmp $testdir/test.wav tmp.wav || exit 1
  $SHORTEN -v2 $testdir/test.wav tmp.shn || exit 1
  cmp $testdir/test.shn tmp.shn || exit 1

  # test wave data to stdout from shorten data on stdin
  $SHORTEN < $testdir/test.wav > tmp.shn || exit 1
  cmp $testdir/test.shn tmp.shn || exit 1

  # test shorten data to stdout from wave data on stdin
  $SHORTEN -x < $testdir/test.shn > tmp.wav || exit 1
  cmp $testdir/test.shn tmp.shn || exit 1

  # miscellaneous option checks (taken from original shorten makefile)
  $SHORTEN -v2 -t wav tmp.wav - | cmp - $testdir/test.shn || exit 1
  $SHORTEN -a2 -t s16 tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -a1024 -t s16x   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -b1024 -t u16    tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -b 4   -t u16x   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -m 0   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -m 32  -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v 0   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v 1   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v 2   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -p1    -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -p16   -t s16hl  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -p16 -v2 -ts16hl tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tulaw  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -talaw  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts8    tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu8    tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts16   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16   tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16x  tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts16hl tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16hl tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -ts16lh tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -tu16lh tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -c2 -tulaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -c2 -talaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -a340 -c16 tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -c2 -p4 -tu16 -b5 tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v2 -t ulaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -v2 -t alaw tmp.wav - | $SHORTEN -x | cmp - tmp.wav || exit 1
  $SHORTEN -q3 -v2 tmp.wav tmp_q3.shn || exit 1
  $SHORTEN -q3 < tmp.wav > tmp_q3.shn || exit 1
  $SHORTEN -x tmp_q3.shn - | $SHORTEN | cmp - tmp_q3.shn || exit 1
  $SHORTEN -x tmp_q3.shn - | $SHORTEN -q3 | cmp - tmp_q3.shn || exit 1
  $SHORTEN -r3 -v2 tmp.wav tmp_r3.shn || exit 1

  rm -f tmp_q3.shn tmp_r3.shn tmp.wav tmp.shn

  echo ""
done

exit 0
